/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.mipush;

import android.content.Context;
import androidx.annotation.NonNull;
import com.moengage.core.Logger;
import com.moengage.core.mipush.MiPushHandler;

public class MiPushManager {
    private static final String TAG = "Core_MiPushManager";
    private MiPushHandler miPushHandler;
    private static MiPushManager instance;

    private MiPushManager() {
        this.loadHandler();
    }

    private void loadHandler() {
        try {
            Class<?> handler = Class.forName("com.moengage.mi.MiPushHandlerImpl");
            this.miPushHandler = (MiPushHandler)handler.newInstance();
        }
        catch (Exception e) {
            Logger.e("Core_MiPushManager loadHandler() : Did not find Push Amp plus Module. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MiPushManager getInstance() {
        if (instance != null) return instance;
        Class<MiPushManager> clazz = MiPushManager.class;
        synchronized (MiPushManager.class) {
            if (instance != null) return instance;
            instance = new MiPushManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initMiPush(@NonNull Context context) {
        if (this.miPushHandler != null && context != null) {
            this.miPushHandler.initMiPushIfRequired(context);
        }
    }

    public boolean hasMiPushModule() {
        return this.miPushHandler != null;
    }
}

