/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.logger;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEngage;
import com.moengage.core.SdkConfig;
import com.moengage.core.logger.LogAdapter;

public class LogcatLogAdapter
implements LogAdapter {
    @Override
    public boolean isLoggable(int logLevel, String logTag) {
        return (SdkConfig.getConfig().isLogEnabledForSignedBuild || MoEngage.isDebugBuild()) && SdkConfig.getConfig().logLevel >= logLevel;
    }

    @Override
    public void log(int logLevel, @Nullable String tag, @NonNull String message) {
        try {
            if (MoEUtils.isEmptyString(message)) {
                return;
            }
            switch (logLevel) {
                case 5: {
                    this.logVerbose(tag, message);
                    break;
                }
                case 4: {
                    Log.d((String)tag, (String)message);
                    break;
                }
                case 3: {
                    Log.w((String)tag, (String)message);
                    break;
                }
                case 1: 
                case 2: {
                    Log.e((String)tag, (String)message);
                    break;
                }
                case 0: {
                    Log.i((String)tag, (String)message);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logVerbose(String tag, String message) {
        if (message.length() > 4000) {
            Log.v((String)tag, (String)message.substring(0, 4000));
            this.logVerbose(tag, message.substring(4000));
        } else {
            Log.v((String)tag, (String)message);
        }
    }
}

