/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.integrations.segment;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.ArrayList;
import java.util.Map;

public class TrackSegmentUserAttributeTask
extends SDKTask {
    private Map<String, Object> userAttributesMap;
    private static final String TAG = "Core_TrackSegmentUserAttributeTask";

    public TrackSegmentUserAttributeTask(Context context, Map<String, Object> userAttributesMap) {
        super(context);
        this.userAttributesMap = userAttributesMap;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("Core_TrackSegmentUserAttributeTask execute() : Transforming identifiers to MoEngage format.");
            this.trackSegmentId();
            ArrayList<String> removeAttributeList = new ArrayList<String>();
            for (Map.Entry<String, Object> entry : this.userAttributesMap.entrySet()) {
                String attributeName = entry.getKey();
                Object attributeValue = entry.getValue();
                if (!(attributeValue instanceof String) || !MoEUtils.isDate((String)attributeValue)) continue;
                MoEHelper.getInstance(this.context).setUserAttributeISODate(attributeName, attributeValue.toString());
                removeAttributeList.add(attributeName);
            }
            for (String attribute : removeAttributeList) {
                this.userAttributesMap.remove(attribute);
            }
            MoEHelper.getInstance(this.context).setUserAttribute(this.userAttributesMap);
        }
        catch (Exception e) {
            Logger.e("Core_TrackSegmentUserAttributeTask execute() : Exception ", e);
        }
        return null;
    }

    private void trackSegmentId() {
        try {
            String segmentId;
            if (this.userAttributesMap.containsKey("USER_ATTRIBUTE_SEGMENT_ID") && !MoEUtils.isEmptyString(segmentId = (String)this.userAttributesMap.get("USER_ATTRIBUTE_SEGMENT_ID"))) {
                ConfigurationProvider.getInstance(this.context).saveSegmentAnonymousId(segmentId);
            }
        }
        catch (Exception e) {
            Logger.e("Core_TrackSegmentUserAttributeTask trackSegmentId() : ", e);
        }
    }

    @Override
    public String getTaskTag() {
        return "TRACK_USER_ATTRIBUTE_SEGMENT";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

