/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.analytics;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.Logger;
import com.moengage.core.MoECoreEvaluator;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.analytics.SourceProcessor;
import com.moengage.core.model.TrafficSource;
import com.moengage.core.model.UserSession;
import java.util.UUID;

public class AnalyticsHelper {
    private static final String TAG = "Core_AnalyticsHelper";
    private static AnalyticsHelper instance = null;
    private UserSession session;
    private MoECoreEvaluator evaluator;
    private SourceProcessor sourceProcessor;

    private AnalyticsHelper(Context context) {
        this.session = MoEDAO.getInstance(context).getLastSavedSession();
        this.evaluator = new MoECoreEvaluator();
        this.sourceProcessor = new SourceProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnalyticsHelper getInstance(Context context) {
        if (instance != null) return instance;
        Class<AnalyticsHelper> clazz = AnalyticsHelper.class;
        synchronized (AnalyticsHelper.class) {
            if (instance != null) return instance;
            instance = new AnalyticsHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void onEventTracked(Event event, Context context) {
        try {
            Logger.v("Core_AnalyticsHelper onEventTracked() : Will update last interaction time if required. Event: " + event.details);
            if (!event.isInteractiveEvent) {
                Logger.v("Core_AnalyticsHelper onEventTracked() : No operation required. Tracked event is non-interactive");
                return;
            }
            if (event.eventName.equals("EVENT_ACTION_USER_ATTRIBUTE")) {
                Logger.v("Core_AnalyticsHelper updateSession() : Need not update session info since user attribute is tracked.");
                return;
            }
            if (MoEHelper.isAppInForeground()) {
                Logger.v("Core_AnalyticsHelper updateSession() : App is in foreground no action required.");
                this.updateLastInteractionTime(MoEUtils.currentMillis());
                return;
            }
            if (this.session == null) {
                Logger.v("Core_AnalyticsHelper onEventTracked() : No previous session. Will create a new session");
                this.batchPreviousDataAndCreateNewSession(context, null, true);
                return;
            }
            if (this.evaluator.hasSessionExpired(this.session.lastInteractionTime, RemoteConfig.getConfig().sessionInActiveTime, MoEUtils.currentMillis())) {
                Logger.v("Core_AnalyticsHelper onEventTracked() : Session has expired.");
                this.batchPreviousDataAndCreateNewSession(context, null, true);
                return;
            }
            this.updateLastInteractionTime(MoEUtils.currentMillis());
        }
        catch (Exception e) {
            Logger.e("Core_AnalyticsHelper onEventTracked() : Exception: ", e);
        }
    }

    void updateLastInteractionTime(long time) {
        if (this.session != null) {
            this.session.lastInteractionTime = time;
        }
    }

    @WorkerThread
    public void onAppOpen(Activity activity) {
        if (this.session != null) {
            Logger.v("Core_AnalyticsHelper onAppOpen() : Current Session " + this.session.toString());
        }
        this.updateUserSessionIfRequired(activity);
    }

    public void onNotificationClicked(Context context, TrafficSource source, boolean isAppInBackground) {
        try {
            Logger.v("Core_AnalyticsHelper onNotificationClicked() : Source " + source);
            this.updateSessionIfRequired(context, source, isAppInBackground);
        }
        catch (Exception e) {
            Logger.e("Core_AnalyticsHelper onNotificationClicked() : ", e);
        }
    }

    private void updateUserSessionIfRequired(Activity activity) {
        try {
            Context context = activity.getApplicationContext();
            TrafficSource currentSource = this.sourceProcessor.getTrafficSourceFromActivity(activity, RemoteConfig.getConfig().additionalSourceIdentifiers);
            this.updateSessionIfRequired(context, currentSource, MoEHelper.isAppInBackground());
        }
        catch (Exception e) {
            Logger.e("Core_AnalyticsHelper onAppOpen() : Exception: ", e);
        }
    }

    private void updateSessionIfRequired(Context context, TrafficSource currentSource, boolean isAppInBackground) {
        Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : New source: " + currentSource);
        if (this.session == null) {
            Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : No saved session for user will create a new session.");
            this.batchPreviousDataAndCreateNewSession(context, currentSource, MoEHelper.isAppInBackground());
            return;
        }
        Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : Current Session: " + this.session);
        boolean hasSessionExpired = this.evaluator.hasSessionExpired(this.session.lastInteractionTime, RemoteConfig.getConfig().sessionInActiveTime, MoEUtils.currentMillis());
        if (hasSessionExpired) {
            Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : Previous session has expired. Will create a new session.");
            this.batchPreviousDataAndCreateNewSession(context, currentSource, MoEHelper.isAppInBackground());
            return;
        }
        TrafficSource savedSource = this.session.trafficSource;
        boolean hasSourceChanged = this.evaluator.hasSourceChanged(savedSource, currentSource);
        if (hasSourceChanged) {
            Logger.v("Core_AnalyticsHelper updateSessionIfRequired() : Source changed. will create a new session");
            this.batchPreviousDataAndCreateNewSession(context, currentSource, isAppInBackground);
        }
    }

    @WorkerThread
    private void batchPreviousDataAndCreateNewSession(Context context, TrafficSource currentSource, boolean isFromBackground) {
        MoEDispatcher.getInstance(context).getBatchHelper().createAndSaveBatches(context, this.session);
        MoEDispatcher.getInstance(context).sendInteractionData();
        this.createAndPersistNewSession(context, currentSource, isFromBackground);
    }

    private UserSession createAndPersistNewSession(Context context, TrafficSource currentSource, boolean isFromBackground) {
        this.session = this.createNewSession(currentSource, isFromBackground);
        Logger.v("Core_AnalyticsHelper createAndPersistNewSession() : New session: " + this.session.toString());
        this.persistUserSession(context, this.session);
        return this.session;
    }

    private UserSession createNewSession(@Nullable TrafficSource currentSource, boolean isFromBackground) {
        long currentTime = MoEUtils.currentMillis();
        return new UserSession(UUID.randomUUID().toString(), MoEUtils.getTimeInISO(currentTime), currentSource, currentTime, isFromBackground);
    }

    private void persistUserSession(Context context, UserSession userSession) {
        MoEDAO.getInstance(context).saveUserSession(userSession);
    }

    public void onAppClose(Context context) {
        this.updateLastInteractionTime(MoEUtils.currentMillis());
        this.persistUserSession(context, this.session);
    }

    @WorkerThread
    public void onLogout(Context context) {
        this.createAndPersistNewSession(context, null, MoEHelper.isAppInBackground());
    }

    @Nullable
    public UserSession getSession() {
        return this.session;
    }
}

