/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.moe.pushlibrary.models.BatchData;
import com.moengage.core.APIManager;
import com.moengage.core.AdvertisingIdClient;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.DataManager;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.RestUtils;
import com.moengage.core.SdkConfig;
import com.moengage.core.analytics.AnalyticsHelper;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.DevicePreferences;
import com.moengage.core.model.MoEJobParameters;
import com.moengage.core.model.PushTokens;
import com.moengage.core.reports.ReportsBatchHelper;
import com.moengage.core.rest.Response;
import com.moengage.core.utils.JsonBuilder;
import java.util.ArrayList;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

class SendInteractionDataTask
extends SDKTask {
    @Nullable
    private final MoEJobParameters jobParameters;
    private final String TAG = "Core_SendInteractionDataTask";

    SendInteractionDataTask(Context context) {
        this(context, null);
    }

    SendInteractionDataTask(Context context, @Nullable MoEJobParameters jobParameters) {
        super(context);
        this.jobParameters = jobParameters;
    }

    @Override
    public TaskResult execute() {
        try {
            if (!RemoteConfig.getConfig().isAppEnabled) {
                return null;
            }
            Logger.v("Core_SendInteractionDataTask executing task");
            MoEDispatcher.getInstance(this.context).getBatchHelper().createAndSaveBatches(this.context, AnalyticsHelper.getInstance(this.context).getSession());
            MoEEventManager.getInstance(this.context).setEventCounter(0);
            String appId = MoEUtils.getAppId();
            if (TextUtils.isEmpty((CharSequence)appId)) {
                Logger.e("Core_SendInteractionDataTask execute: App-id not present cannot make report add call.");
                return null;
            }
            this.sendInteractionData(appId);
            this.releaseJobLockIfRequired();
            Logger.v("Core_SendInteractionDataTask : completed task");
            return null;
        }
        catch (Exception e) {
            Logger.e("Core_SendInteractionDataTask : execute() ", e);
            return null;
        }
    }

    private void releaseJobLockIfRequired() {
        if (Build.VERSION.SDK_INT >= 21 && this.jobParameters != null) {
            Logger.v("Core_SendInteractionDataTask releaseJobLockIfRequired() : Trying to release job lock.");
            this.jobParameters.jobCompleteListener.jobComplete(this.jobParameters);
        }
    }

    @Override
    public String getTaskTag() {
        return "SEND_INTERACTION_DATA";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    private void sendInteractionData(String appId) {
        boolean result = false;
        ArrayList<BatchData> batchedData = null;
        String endpoint = "v2/sdk/report/" + appId;
        if (this.shouldSendDataToTestServer()) {
            endpoint = "integration/send_report_add_call";
        }
        ReportsBatchHelper batchHelper = new ReportsBatchHelper();
        while (true) {
            batchedData = MoEDAO.getInstance(this.context).getBatchedData(100);
            Logger.d("SendInteractionDataTask : sendInteractionData:Fetching interaction data in batches");
            if (batchedData == null || batchedData.isEmpty()) {
                Logger.d("SendInteractionDataTask : sendInteractionData: Found Nothing to send");
                return;
            }
            for (BatchData data : batchedData) {
                BatchData batch = batchHelper.updateBatchIfRequired(this.context, data);
                try {
                    String requestId = this.getRequestID(data.batchDataJson);
                    JSONObject requestBody = this.cleanBody(data.batchDataJson).put("query_params", (Object)this.getQueryParams());
                    Response response = APIManager.reportAdd(appId, endpoint, requestId, requestBody);
                    if (response != null && (response.responseCode == 200 || response.responseCode == MoEConstants.ENCRYPTION_FAIL)) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    Logger.e("SendInteractionDataTask : API failed", e);
                    result = false;
                }
                if (result) {
                    Logger.d("SendInteractionDataTask : Batch sent successfully deleting batch");
                    MoEDAO.getInstance(this.context).deleteBatch(batch);
                    continue;
                }
                this.scheduleRetryIfRequired();
                break;
            }
            if (!result) break;
            batchedData.clear();
        }
    }

    private void scheduleRetryIfRequired() {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.context);
        int retryCount = provider.getImmediateRetryCount();
        switch (retryCount) {
            case 0: {
                new DataManager().scheduleImmediateRetry(this.context, DataManager.IMMEDIATE_RETRY_INTERVAL_ATTEMPT_ONE);
                provider.setImmediateRetryCount(++retryCount);
                break;
            }
            case 1: {
                new DataManager().scheduleImmediateRetry(this.context, DataManager.IMMEDIATE_RETRY_INTERVAL_ATTEMPT_TWO);
                break;
            }
            default: {
                provider.setImmediateRetryCount(0);
            }
        }
    }

    private boolean shouldSendDataToTestServer() {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.context);
        boolean isDeviceRegisteredForVerification = provider.isDeviceRegisteredForVerification();
        long registrationTime = provider.getVerificationRegistrationTime();
        return isDeviceRegisteredForVerification && registrationTime + MoEUtils.minutesToMillis(DataManager.MAX_TEST_DEVICE_TIME) > MoEUtils.currentMillis();
    }

    @Nullable
    private String getRequestID(JSONObject batchData) {
        try {
            return batchData.getString("MOE-REQUEST-ID");
        }
        catch (JSONException e) {
            Logger.e("SendInteractionDataTask: getRequestID(): Exception ", e);
            return null;
        }
    }

    private JSONObject cleanBody(JSONObject batchData) {
        batchData.remove("MOE-REQUEST-ID");
        return batchData;
    }

    private JSONObject getQueryParams() throws JSONException {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.context);
        JsonBuilder builder = RestUtils.getDefaultParams(this.context);
        builder.putString("device_tz", TimeZone.getDefault().getID());
        DevicePreferences devicePreferences = MoEDAO.getInstance(this.context).getDevicePreferences();
        if (!devicePreferences.isPushOptedOut) {
            PushTokens pushTokens = MoEDAO.getInstance(this.context).getPushTokens();
            if (!MoEUtils.isEmptyString(pushTokens.fcmToken)) {
                builder.putString("push_id", pushTokens.fcmToken);
            }
            if (!MoEUtils.isEmptyString(pushTokens.oemToken)) {
                builder.putString("mi_push_id", pushTokens.oemToken);
            }
        }
        if (!devicePreferences.isDataTrackingOptedOut) {
            String androidId = MoEUtils.getAndroidID(this.context);
            if (!TextUtils.isEmpty((CharSequence)androidId)) {
                builder.putString("android_id", androidId);
            }
            if (!SdkConfig.getConfig().isGaidTrackingOptedOut) {
                AdvertisingIdClient.AdInfo adInfo;
                String gaid = provider.getStoredGAID();
                if (TextUtils.isEmpty((CharSequence)gaid) && (adInfo = MoEUtils.getAdvertisementInfo(this.context)) != null) {
                    gaid = adInfo.getId();
                    provider.storeGAID(gaid);
                }
                if (!TextUtils.isEmpty((CharSequence)gaid)) {
                    builder.putString("moe_gaid", gaid);
                }
            }
            builder.putString("os_ver", String.valueOf(Build.VERSION.SDK_INT));
            builder.putString("model", Build.MODEL);
            builder.putString("app_version_name", provider.getAppVersionName());
            String nwType = MoEUtils.getNetworkType(this.context);
            if (!TextUtils.isEmpty((CharSequence)nwType)) {
                builder.putString("networkType", nwType);
            }
        }
        return builder.build();
    }
}

