/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;

public class Properties {
    private static final String TAG = "Core_Properties";
    private PayloadBuilder payloadBuilder = new PayloadBuilder();

    public Properties addAttribute(@NonNull String attributeName, Object attributeValue) {
        if (this.isAcceptedDataType(attributeValue)) {
            this.addAttributeInternal(attributeName, attributeValue);
        }
        return this;
    }

    public Properties addDateIso(@NonNull String attributeName, String attributeValue) {
        this.payloadBuilder.putAttrISO8601Date(attributeName, attributeValue);
        return this;
    }

    public Properties addDateEpoch(@NonNull String attributeName, long attributeValue) {
        this.payloadBuilder.putAttrDateEpoch(attributeName, attributeValue);
        return this;
    }

    public Properties setNonInteractive() {
        this.payloadBuilder.setNonInteractive();
        return this;
    }

    private void addAttributeInternal(String attributeName, Object attributeValue) {
        try {
            if (MoEUtils.isEmptyString(attributeName)) {
                return;
            }
            if (attributeValue instanceof GeoLocation) {
                this.payloadBuilder.putAttrLocation(attributeName, (GeoLocation)attributeValue);
            } else if (attributeValue instanceof Date) {
                this.payloadBuilder.putAttrDate(attributeName, (Date)attributeValue);
            } else {
                this.payloadBuilder.putAttrObject(attributeName, attributeValue);
            }
        }
        catch (Exception e) {
            Logger.e("Core_Properties addAttributeInternal() : ", e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public PayloadBuilder getPayload() {
        return this.payloadBuilder;
    }

    private boolean isAcceptedDataType(Object attributeValue) {
        return attributeValue instanceof String || attributeValue instanceof Integer || attributeValue instanceof Long || attributeValue instanceof Double || attributeValue instanceof Float || attributeValue instanceof Boolean || attributeValue instanceof Date || attributeValue instanceof GeoLocation || attributeValue instanceof JSONArray || attributeValue instanceof JSONObject;
    }
}

