/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import com.moengage.core.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MoEFileManager {
    private static final String TAG = "Core_MoEFileManager";
    private final String FILE_PATH_SEPARATOR = "/";
    private final String MOENGAGE_SUBFOLDER = "moengage";
    private Context context;

    public MoEFileManager(Context context) {
        this.context = context;
        this.createBaseFolderIfRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImageFile(@NonNull String directoryName, @NonNull String fileName, @NonNull Bitmap bitmap) {
        if (!this.doesDirectoryExists(directoryName)) {
            this.createDirectory(directoryName);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.basePath() + "/" + directoryName + "/" + fileName);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
        }
        catch (Exception e) {
            Logger.e("Core_MoEFileManager saveImageFile() : ", e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                Logger.e("Core_MoEFileManager saveImageFile() : ", e);
            }
        }
    }

    public boolean doesDirectoryExists(String directoryName) {
        try {
            File file = new File(this.basePath() + "/" + directoryName);
            return file.exists();
        }
        catch (Exception e) {
            Logger.e("Core_MoEFileManager doesDirectoryExists() : Directory with name " + directoryName + " does not exist.");
            return false;
        }
    }

    public boolean createDirectory(String directoryName) {
        File file = new File(this.basePath() + "/" + directoryName);
        return file.mkdir();
    }

    public void deleteFolder(String folder) {
        File directory = new File(this.basePath() + "/" + folder);
        this.deleteDirectory(directory);
    }

    public boolean fileExistsInDirectory(String directoryName, String fileName) {
        File file = new File(this.basePath() + "/" + directoryName + "/" + fileName);
        return file.exists();
    }

    public String getPathForFile(String directoryName, String fileName) {
        File file = new File(this.basePath() + "/" + directoryName + "/" + fileName);
        return file.getAbsolutePath();
    }

    @NonNull
    private String basePath() {
        return this.context.getFilesDir().getAbsolutePath() + "/" + "moengage";
    }

    private void createBaseFolderIfRequired() {
        File file = new File(this.basePath());
        if (!file.exists()) {
            Logger.v("Core_MoEFileManager createBaseFolderIfRequired() : MoEngage base folder does not exist. Will create it.");
            file.mkdir();
        } else {
            Logger.v("Core_MoEFileManager createBaseFolderIfRequired() : MoEngage base folder exists. Need not create another one.");
        }
    }

    public void clearMoEngageFiles() {
        File file = new File(this.basePath());
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            this.deleteDirectory(file);
        }
    }

    private void deleteDirectory(File directory) {
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            directory.delete();
            return;
        }
        for (File file : fileList) {
            if (file.isDirectory()) {
                this.deleteDirectory(file);
                continue;
            }
            file.delete();
        }
        directory.delete();
    }

    public File saveGif(String directoryName, String fileName, InputStream gifStream) {
        try {
            if (!this.doesDirectoryExists(directoryName)) {
                this.createDirectory(directoryName);
            }
            int bufferLength = 0;
            byte[] buffer = new byte[1024];
            File file = new File(this.basePath() + "/" + directoryName + "/" + fileName);
            FileOutputStream fileOutput = new FileOutputStream(file);
            while ((bufferLength = gifStream.read(buffer)) > 0) {
                fileOutput.write(buffer, 0, bufferLength);
            }
            fileOutput.close();
            return file;
        }
        catch (Exception e) {
            Logger.e("Core_MoEFileManager saveGif() : ", e);
            return null;
        }
    }

    public File getFileByName(String directory, String fileName) {
        return new File(this.basePath() + "/" + directory, fileName);
    }
}

