/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.moengage.core.APIManager;
import com.moengage.core.AdvertisingIdClient;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.RestUtils;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.DevicePreferences;
import com.moengage.core.model.PushTokens;
import com.moengage.core.model.TokenState;
import com.moengage.core.rest.Response;
import com.moengage.core.utils.JsonBuilder;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceAddTask
extends SDKTask {
    private static final String TAG = "Core_DeviceAddTask";
    private String requestTime;
    private String batchId;
    private ConfigurationProvider provider;
    private TokenState tokenState;
    private DevicePreferences devicePreference;

    DeviceAddTask(Context context, DevicePreferences devicePreference) {
        super(context);
        this.provider = ConfigurationProvider.getInstance(this.context);
        this.tokenState = new TokenState();
        this.devicePreference = devicePreference;
    }

    @Override
    public TaskResult execute() {
        Logger.v("Core_DeviceAddTask execution started");
        try {
            String appId = MoEUtils.getAppId();
            if (TextUtils.isEmpty((CharSequence)appId)) {
                Logger.e("Core_DeviceAddTask execute: Cannot make device add call, app id not present.");
                this.taskResult.setIsSuccess(false);
                return this.taskResult;
            }
            Response response = APIManager.deviceAdd(appId, this.getBody(), this.getRequestId());
            if (response != null && response.responseCode == 200) {
                this.taskResult.setIsSuccess(true);
            }
        }
        catch (Exception e) {
            Logger.e("Core_DeviceAddTask execute() : ", e);
        }
        Logger.v("Core_DeviceAddTask execution completed");
        this.taskResult.setPayload(this.tokenState);
        return this.taskResult;
    }

    @Override
    public String getTaskTag() {
        return "DEVICE_ADD";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    private JSONObject getSDKMeta() throws JSONException {
        JSONObject metaJSON = new JSONObject();
        this.batchId = MoEUtils.getRequestId();
        this.requestTime = MoEUtils.currentISOTime();
        metaJSON.put("bid", (Object)this.batchId).put("request_time", (Object)this.requestTime).put("dev_pref", (Object)this.getPreferencesJson());
        return metaJSON;
    }

    private JSONObject getQueryParams() throws JSONException {
        JsonBuilder builder = RestUtils.getDefaultParams(this.context);
        builder.putString("device_tz", TimeZone.getDefault().getID());
        if (!this.devicePreference.isPushOptedOut) {
            PushTokens pushTokens = MoEDAO.getInstance(this.context).getPushTokens();
            if (!MoEUtils.isEmptyString(pushTokens.fcmToken)) {
                builder.putString("push_id", pushTokens.fcmToken);
                this.tokenState.isSendingFcmToken = true;
            }
            if (!MoEUtils.isEmptyString(pushTokens.oemToken)) {
                builder.putString("mi_push_id", pushTokens.oemToken);
                this.tokenState.isSendingSecondaryToken = true;
            }
        }
        if (!this.provider.isDataTrackingOptedOut()) {
            String androidId = MoEUtils.getAndroidID(this.context);
            if (!TextUtils.isEmpty((CharSequence)androidId)) {
                builder.putString("android_id", androidId);
            }
            if (!SdkConfig.getConfig().isGaidTrackingOptedOut) {
                AdvertisingIdClient.AdInfo adInfo;
                String gaid = this.provider.getStoredGAID();
                if (TextUtils.isEmpty((CharSequence)gaid) && (adInfo = MoEUtils.getAdvertisementInfo(this.context)) != null) {
                    gaid = adInfo.getId();
                    this.provider.storeGAID(gaid);
                }
                if (!TextUtils.isEmpty((CharSequence)gaid)) {
                    builder.putString("moe_gaid", gaid);
                }
            }
            builder.putString("os_ver", String.valueOf(Build.VERSION.SDK_INT));
            builder.putString("model", Build.MODEL);
            builder.putString("app_version_name", this.provider.getAppVersionName());
            String nwType = MoEUtils.getNetworkType(this.context);
            if (!TextUtils.isEmpty((CharSequence)nwType)) {
                builder.putString("networkType", nwType);
            }
        }
        return builder.build();
    }

    private JSONObject getBody() throws JSONException {
        JsonBuilder requestBody = this.getDeviceInfo().putJsonObject("meta", this.getSDKMeta()).putJsonObject("query_params", this.getQueryParams());
        return requestBody.build();
    }

    private JsonBuilder getDeviceInfo() throws JSONException {
        AdvertisingIdClient.AdInfo adInfo;
        String operator;
        JsonBuilder deviceInfo = new JsonBuilder();
        if (SdkConfig.getConfig().isDeviceAttributeTrackingOptedOut || this.provider.isDataTrackingOptedOut()) {
            return deviceInfo;
        }
        deviceInfo.putString("OS_VERSION", Build.VERSION.RELEASE).putInt("OS_API_LEVEL", Build.VERSION.SDK_INT).putString("DEVICE", Build.DEVICE).putString("MODEL", Build.MODEL).putString("PRODUCT", Build.PRODUCT).putString("MANUFACTURER", Build.MANUFACTURER);
        String deviceId = MoEUtils.getAndroidID(this.context);
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceInfo.putString("DEVICE_ID", deviceId);
        }
        if (!TextUtils.isEmpty((CharSequence)(operator = MoEUtils.getOperatorName(this.context)))) {
            deviceInfo.putString("CARRIER", operator);
        }
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        if (wm != null) {
            wm.getDefaultDisplay().getMetrics(outMetrics);
            deviceInfo.putInt("DENSITYDPI", outMetrics.densityDpi).putInt("WIDTH", outMetrics.widthPixels).putInt("HEIGHT", outMetrics.heightPixels);
        }
        if (!SdkConfig.getConfig().isGaidTrackingOptedOut && null != (adInfo = MoEUtils.getAdvertisementInfo(this.context))) {
            deviceInfo.putString("MOE_GAID", adInfo.getId()).putInt("MOE_ISLAT", adInfo.isLimitAdTrackingEnabled());
        }
        return deviceInfo;
    }

    private String getRequestId() {
        return MoEUtils.getSha1ForString(this.batchId + this.requestTime + this.provider.getCurrentUserId());
    }

    private JSONObject getPreferencesJson() throws JSONException {
        JsonBuilder preferences = new JsonBuilder();
        preferences.putBoolean("push_p", !this.devicePreference.isPushOptedOut);
        preferences.putBoolean("in_app_p", !this.devicePreference.isInAppOptedOut);
        preferences.putBoolean("e_t_p", !this.devicePreference.isDataTrackingOptedOut);
        return preferences.build();
    }
}

