/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.moengage.core.DataSyncJob;
import com.moengage.core.Logger;
import com.moengage.core.MoEAlarmReceiver;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.SdkConfig;
import com.moengage.core.SendInteractionDataTask;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.model.MoEJobParameters;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DataManager {
    private static final String TAG = "Core_DataManager";
    public static String ACTION_DATA_SENDING = "MOE_ACTION_DATA_SENDING";
    private static final int APP_CLOSE_DATA_SYNC_JOB_ID = 90001;
    private static final int APP_CLOSE_DATA_SYNC_ALARM_ID = 90002;
    public static final int BACKGROUND_DATA_SYNC_JOB_ID = 90003;
    public static final int BACKGROUND_DATA_SYNC_ALARM_ID = 90004;
    public static final int IMMEDIATE_RETRY_DATA_SYNC_JOB_ID = 90005;
    public static final int IMMEDIATE_RETRY_DATA_SYNC_ALARM_ID = 90006;
    public static final int BATCH_SIZE = 100;
    public static int MAX_TEST_DEVICE_TIME = 60;
    public static int IMMEDIATE_RETRY_INTERVAL_ATTEMPT_ONE = 60;
    public static int IMMEDIATE_RETRY_INTERVAL_ATTEMPT_TWO = 180;
    public static int APP_CLOSE_SYNC_INTERVAL = 3;

    void scheduleDataSending(@NonNull Context context) {
        if (context == null) {
            Logger.e("Core_DataManagerscheduleDataSending() : context is null");
            return;
        }
        try {
            if (Build.VERSION.SDK_INT < 21) {
                this.scheduleDataSendingAlarm(context, 90002, APP_CLOSE_SYNC_INTERVAL);
            } else {
                this.scheduleDataSendingJob(context, 90001, APP_CLOSE_SYNC_INTERVAL);
            }
            this.scheduleBackgroundSyncIfRequired(context);
        }
        catch (Exception e) {
            Logger.e("Core_DataManagerscheduleDataSending() :  Exception: ", e);
        }
    }

    public void scheduleImmediateRetry(Context context, int seconds) {
        Logger.v("Core_DataManager scheduleImmediateRetry() : Scheduling immediate retry, delay: " + seconds);
        if (Build.VERSION.SDK_INT < 21) {
            this.scheduleDataSendingAlarm(context, 90006, seconds);
        } else {
            this.scheduleDataSendingJob(context, 90005, seconds);
        }
    }

    public void backgroundSync(Context context, MoEJobParameters jobParameters) {
        Logger.v("Core_DataManager backgroundSync() : ");
        TaskManager.getInstance().startTask(new SendInteractionDataTask(context, jobParameters));
        this.scheduleBackgroundSyncIfRequired(context);
    }

    private void scheduleBackgroundSyncIfRequired(Context context) {
        if (!SdkConfig.getConfig().isBackgroundSyncEnabled) {
            return;
        }
        long syncInterval = RemoteConfig.getConfig().dataSyncRetryInterval / 1000L;
        Logger.v("Core_DataManager scheduleBackgroundSyncIfRequired() : Will schedule background sync.");
        if (Build.VERSION.SDK_INT < 21) {
            this.scheduleDataSendingAlarm(context, 90004, syncInterval);
        } else {
            this.scheduleDataSendingJob(context, 90003, syncInterval);
        }
        Logger.v("Core_DataManager scheduleBackgroundSyncIfRequired() : Background sync scheduled.");
    }

    private void scheduleDataSendingAlarm(@NonNull Context context, int alarmId, long syncInterval) {
        Logger.v("Core_DataManager scheduleDataSending() alarmId: " + alarmId + " interval: " + syncInterval);
        Intent alarmIntent = new Intent(context, MoEAlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)alarmId, (Intent)alarmIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.set(0, MoEUtils.secondsToMillis(MoEUtils.currentSeconds() + syncInterval), pendingIntent);
        }
    }

    @TargetApi(value=21)
    private void scheduleDataSendingJob(@NonNull Context context, int jobId, long syncInterval) {
        Logger.v("Core_DataManager scheduleDataSendingJob() JobId: " + jobId + " interval: " + syncInterval);
        ComponentName serviceComponent = new ComponentName(context, DataSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(jobId, serviceComponent);
        builder.setRequiredNetworkType(1);
        builder.setOverrideDeadline(MoEUtils.secondsToMillis(syncInterval * 2L));
        builder.setMinimumLatency(MoEUtils.secondsToMillis(syncInterval));
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.schedule(builder.build());
        }
    }
}

