/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.telephony.PhoneNumberUtils;
import androidx.annotation.NonNull;
import com.moengage.core.MoEUtils;

public class ActionManagerBase {
    private static final String TAG = "ActionManagerBase";

    protected boolean isPhoneNumberValid(String phoneNumber) {
        if (MoEUtils.isEmptyString(phoneNumber)) {
            return false;
        }
        for (int i = 0; i < phoneNumber.length(); ++i) {
            if (PhoneNumberUtils.isDialable((char)phoneNumber.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected void triggerCallIntent(@NonNull Context context, @NonNull String phoneNumber) {
        Intent callIntent = new Intent("android.intent.action.DIAL");
        callIntent.setData(Uri.parse((String)("tel:" + Uri.encode((String)phoneNumber))));
        context.startActivity(callIntent);
    }

    protected void triggerShareIntent(Context context, String content) {
        Intent sharingIntent = new Intent("android.intent.action.SEND");
        sharingIntent.setType("text/plain");
        sharingIntent.putExtra("android.intent.extra.TEXT", content);
        context.startActivity(Intent.createChooser((Intent)sharingIntent, (CharSequence)"Share via"));
    }
}

