/*
 * Decompiled with CFR 0.152.
 */
package com.moe.pushlibrary.utils;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MoEHelperUtils {
    private static final String EVENT_ACTION = "EVENT_ACTION";
    public static final String EVENT_ATTRS = "EVENT_ATTRS";
    public static final String EVENT_ATTRS_CUST = "EVENT_ATTRS_CUST";
    public static final String EVENT_G_TIME = "EVENT_G_TIME";
    public static final String EVENT_L_TIME = "EVENT_L_TIME";
    public static final String EVENT_NON_INTERACTIVE = "N_I_E";

    private MoEHelperUtils() {
    }

    public static Bundle convertJSONObjecttoBundle(JSONObject jsonObject) {
        Bundle newBundle = null;
        try {
            Iterator keys = jsonObject.keys();
            newBundle = new Bundle();
            while (keys.hasNext()) {
                String nextKey = (String)keys.next();
                Object nextValue = jsonObject.get(nextKey);
                if (nextValue instanceof Integer) {
                    newBundle.putInt(nextKey, ((Integer)nextValue).intValue());
                    continue;
                }
                if (nextValue instanceof Boolean) {
                    newBundle.putBoolean(nextKey, ((Boolean)nextValue).booleanValue());
                    continue;
                }
                if (nextValue instanceof String) {
                    newBundle.putString(nextKey, (String)nextValue);
                    continue;
                }
                if (nextValue instanceof Byte) {
                    newBundle.putByte(nextKey, ((Byte)nextValue).byteValue());
                    continue;
                }
                if (nextValue instanceof Character) {
                    newBundle.putChar(nextKey, ((Character)nextValue).charValue());
                    continue;
                }
                if (nextValue instanceof Double) {
                    newBundle.putDouble(nextKey, ((Double)nextValue).doubleValue());
                    continue;
                }
                if (nextValue instanceof Float) {
                    newBundle.putFloat(nextKey, ((Float)nextValue).floatValue());
                    continue;
                }
                if (nextValue instanceof Long) {
                    newBundle.putLong(nextKey, ((Long)nextValue).longValue());
                    continue;
                }
                if (!(nextValue instanceof Short)) continue;
                newBundle.putShort(nextKey, ((Short)nextValue).shortValue());
            }
        }
        catch (Exception e) {
            return newBundle;
        }
        return newBundle;
    }

    public static void copyCouponCodeToClipboard(Context mContext, String couponcode) {
        MoEHelperUtils.copyToClipboard(mContext, couponcode);
        MoEHelperUtils.showToast("Coupon code copied to clipboard", mContext);
    }

    public static void copyTextToClipboardAndShowToast(Context context, String copyText, String message) {
        MoEHelperUtils.copyToClipboard(context, copyText);
        MoEHelperUtils.showToast(message, context);
    }

    public static void showToast(String message, Context mContext) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            Toast.makeText((Context)mContext, (CharSequence)message, (int)0).show();
        }
    }

    private static void copyToClipboard(Context mContext, String couponCode) {
        ClipboardManager clipboard = (ClipboardManager)mContext.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"coupon code", (CharSequence)couponCode);
        clipboard.setPrimaryClip(clip);
    }

    public static Intent getLauncherActivityIntent(Context context) {
        PackageManager pm = context.getPackageManager();
        return pm.getLaunchIntentForPackage(context.getPackageName());
    }

    public static Bitmap downloadImageBitmap(String imageUrl) {
        if (imageUrl == null || imageUrl.length() == 0) {
            Logger.e("Null or empty Url string passed to image bitmap download. Not attempting download.");
            return null;
        }
        Bitmap bitmap = null;
        try {
            InputStream inputStream = new URL(imageUrl).openStream();
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            Logger.e(String.format("Exception in image bitmap download for Url: %s", imageUrl), e);
        }
        return bitmap;
    }

    public static JSONObject getDatapointJSON(String action, JSONObject actionAttrs) {
        if (actionAttrs.has(EVENT_G_TIME) && actionAttrs.has(EVENT_L_TIME)) {
            try {
                actionAttrs.put(EVENT_ACTION, (Object)action);
            }
            catch (Exception e) {
                Logger.e("MoEHelperUtils: getDataPointJson ", e);
            }
            return actionAttrs;
        }
        return MoEHelperUtils.getDatapointJSON(action, actionAttrs, Long.toString(MoEUtils.currentMillis()), MoEUtils.getDateDataPointFormat());
    }

    public static JSONObject getDatapointJSON(String action, JSONObject actionAttrs, String gtime, String ltime) {
        return MoEHelperUtils.getDatapointJSON(action, actionAttrs, null, gtime, ltime);
    }

    public static JSONObject getDatapointJSON(String action, JSONObject generalAttrs, JSONObject customAttrs, String gtime, String ltime) {
        JSONObject jsonInteraction = new JSONObject();
        try {
            jsonInteraction.put(EVENT_ACTION, (Object)action);
            if (null != generalAttrs) {
                jsonInteraction.put(EVENT_ATTRS, (Object)generalAttrs.toString());
            }
            if (null != customAttrs && customAttrs.length() != 0) {
                jsonInteraction.put(EVENT_ATTRS_CUST, (Object)customAttrs.toString());
            }
            jsonInteraction.put(EVENT_G_TIME, (Object)gtime);
            jsonInteraction.put(EVENT_L_TIME, (Object)ltime);
            return jsonInteraction;
        }
        catch (Exception e) {
            Logger.e("MoEHelperUtils:getDataPointJson", e);
            return null;
        }
    }

    public static boolean hasPermission(Context appContext, String permission2) {
        try {
            if (null == appContext || TextUtils.isEmpty((CharSequence)permission2)) {
                return false;
            }
            PackageManager pm = appContext.getPackageManager();
            return pm.checkPermission(permission2, appContext.getPackageName()) == 0;
        }
        catch (Exception ignored) {
            Logger.e("MoEHelperUtils: hasPermission ", ignored);
            return false;
        }
    }

    public static JSONObject transformEventAttributesForEvaluationPackage(JSONObject eventAttributes) {
        JSONObject attributes = new JSONObject();
        try {
            JSONObject customAttributes;
            if (eventAttributes.has(EVENT_ATTRS)) {
                attributes = new JSONObject(eventAttributes.getString(EVENT_ATTRS));
            }
            if (eventAttributes.has(EVENT_ATTRS_CUST) && (customAttributes = new JSONObject(eventAttributes.getString(EVENT_ATTRS_CUST))).has("timestamp")) {
                JSONArray timestampAttrs = customAttributes.getJSONArray("timestamp");
                for (int index = 0; index < timestampAttrs.length(); ++index) {
                    JSONObject timeAttrJSON = timestampAttrs.getJSONObject(index);
                    Iterator iterator = timeAttrJSON.keys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        Date date = new Date();
                        date.setTime(timeAttrJSON.getLong(key));
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
                        attributes.put(key, (Object)format.format(date));
                    }
                }
            }
        }
        catch (JSONException e) {
            Logger.e("MoEHelperUtils transformEventAttributesForEvaluationPackage() : ");
        }
        return attributes;
    }
}

