/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 * All rights reserved.
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use
 * of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that
 * all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or
 * promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written
 * permission. Any such redistribution must retain the above copyright notice, this list of
 * conditions and the following disclaimer.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.logger;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.Log;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEngage;
import com.moengage.core.SdkConfig;

/**
 * @author Umang Chamaria
 * Date: 10/05/20
 */
public class LogcatLogAdapter implements LogAdapter {

  @Override public boolean isLoggable(int logLevel, String logTag) {
    return (SdkConfig.getConfig().isLogEnabledForSignedBuild || MoEngage.isDebugBuild())
        && SdkConfig.getConfig().logLevel >= logLevel;
  }

  @Override public void log(int logLevel, @Nullable String tag, @NonNull String message) {
    try {
      if (MoEUtils.isEmptyString(message)) return;
      switch (logLevel) {
        case Logger.VERBOSE:
          logVerbose(tag, message);
          break;
        case Logger.DEBUG:
          Log.d(tag, message);
          break;
        case Logger.WARN:
          Log.w(tag, message);
          break;
        case Logger.ERROR:
        case Logger.FATAL:
          Log.e(tag, message);
          break;
        case Logger.INFO:
          Log.i(tag, message);
          break;
      }
    } catch (Exception e) {

    }
  }

  private void logVerbose(String tag, String message) {
    if (message.length() > 4000) {
      Log.v(tag, message.substring(0, 4000));
      logVerbose(tag, message.substring(4000));
    } else {
      Log.v(tag, message);
    }
  }
}
