/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 * All rights reserved.
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use
 * of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that
 * all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or
 * promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written
 * permission. Any such redistribution must retain the above copyright notice, this list of
 * conditions and the following disclaimer.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.logger;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.Logger;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Umang Chamaria
 * Date: 10/05/20
 */
public class LogPrinter implements Printer {

  private List<LogAdapter> logAdapters = new ArrayList<>();
  private String tag = "MoEngage_v" + MoEHelperConstants.LIB_VERSION;
  ;

  @Override public void setTag(String tag) {
    this.tag = tag;
  }

  @SuppressWarnings("ConstantConditions") @Override
  public void addAdapter(@NonNull LogAdapter logAdapter) {
    if (logAdapter != null) {
      logAdapters.add(logAdapter);
    }
  }

  @SuppressWarnings("ConstantConditions") @Override
  public void removeAdapter(@NonNull LogAdapter logAdapter) {
    if (logAdapter != null) {
      logAdapters.remove(logAdapter);
    }
  }

  @Override public void clearAllAdapters() {
    logAdapters.clear();
  }

  @Override public void v(String message, @Nullable Throwable throwable) {
    log(Logger.VERBOSE, tag, message, throwable);
  }

  @Override public void d(String message, @Nullable Throwable throwable) {
    log(Logger.DEBUG, tag, message, throwable);
  }

  @Override public void w(String message, @Nullable Throwable throwable) {
    log(Logger.WARN, tag, message, throwable);
  }

  @Override public void e(String message, @Nullable Throwable throwable) {
    log(Logger.ERROR, tag, message, throwable);
  }

  @Override public void f(String message, @Nullable Throwable throwable) {
    log(Logger.FATAL, tag, message, throwable);
  }

  @Override public void i(String message, @Nullable Throwable throwable) {
    log(Logger.INFO, tag, message, throwable);
  }

  @Override
  public void log(int logLevel, String tag, String message, @Nullable Throwable throwable) {
    for (LogAdapter logAdapter : logAdapters) {
      if (logAdapter.isLoggable(logLevel, tag)) {
        if (throwable != null) {
          message += " : " + LogUtils.getStackTraceString(throwable);
        }
        logAdapter.log(logLevel, tag, message);
      }
    }
  }
}
