/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core;

import com.moe.pushlibrary.utils.MoEHelperConstants;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Umang Chamaria
 */
public class RemoteConfigDefault {

  public static boolean LOG_ENTRY_STATUS = false;

  public static String LOG_ENTRY_TOKEN = null;

  public static long PUSH_AMP_SYNC_INTERVAL = 10800000;

  public static boolean ACCOUNT_STATUS = true;

  public static boolean IN_APP_STATUS = true;

  public static boolean GEO_FENCE_STATUS = true;

  public static boolean PUSH_AMP_STATUS = false;

  public static int EVENT_BATCH_COUNT = 30;

  public static long DATA_SYNC_RETRY_INTERVAL = 1800000L;

  public static boolean PERIODIC_FLUSH_STATE = true;

  public static long PERIODIC_FLUSH_TIME = 60;

  public static long PUSH_AMP_CAMPAIGN_EXPIRY_TIME = 2419200000L;

  public static boolean REAL_TIME_TRIGGER_STATUS = false;

  public static long REAL_TIME_TRIGGER_SYNC_INTERVAL = 10800000L;

  public static long USER_ATTRIBUTE_CACHING_TIME = 1800000;

  public static long DEFAULT_SESSION_INACTIVE_TIME = 1800000L;

  public static Set<String> DEFAULT_FLUSH_EVENTS = new HashSet<>();

  public static Set<String> DEFAULT_GDPR_WHITELIST_EVENTS = new HashSet<>();

  static {
    // default flush events
    DEFAULT_FLUSH_EVENTS.add(MoEHelperConstants.NOTIFICATION_RECEIVED_MOE);
    // push notification stats events
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEHelperConstants.NOTIFICATION_RECEIVED_MOE);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEHelperConstants.EVENT_NOTIFICATION_CLICKED);
    // in-app stats events
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEConstants.EVENT_IN_APP_SHOWN);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEConstants.EVENT_IN_APP_CLICKED);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEConstants.EVENT_IN_APP_AUTO_DISMISS);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEConstants.EVENT_IN_APP_DISMISSED);

    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEConstants.EVENT_ACTION_COUPON_CODE_COPY);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEHelperConstants.NOTIFICATION_OFFLINE_MOE);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEHelperConstants.DT_CAMPAIGN_SCHEDULED);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEConstants.EVENT_ACTION_ACTIVITY_START);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEHelperConstants.APP_RATED_EVENT);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEHelperConstants.TOKEN_EVENT);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEConstants.MOE_APP_EXIT_EVENT);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEHelperConstants.EVENT_APP_INSTALL);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEHelperConstants.EVENT_APP_UPDATE);

    //card stats events
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEConstants.MOE_CARD_DELIVERED);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEConstants.MOE_CARD_IMPRESSION);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEConstants.MOE_CARD_CLICKED);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEConstants.MOE_CARD_DISMISSED);
    DEFAULT_GDPR_WHITELIST_EVENTS.add(MoEConstants.MOE_INBOX_OPEN);
  }
  public static String BLOCKED_UNIQUE_ID_REGEX = null;

  public static boolean MI_PUSH_APP_STATUS = true;

  static String DEFAULT_DATA_ENCRYPTION_KEY =
      "28caa46a6e9c77fbe291287e4fec061f";//#Ignore TruffleHog
}
