/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.Lifecycle.Event;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.moengage.core.executor.TaskManager;

/**
 * Lifecycle observer for LifecycleOwner state change
 * {@link Lifecycle#addObserver(LifecycleObserver)}
 * @author Arshiya Khanum
 * Date: 2020/08/20
 *
 * @since 10.4.00
 */

public class MoELifeCycleObserver implements LifecycleObserver {

  private static final String TAG = MoEConstants.MODULE_TAG +"MoELifeCycleObserver";
  private Context context;

  @SuppressWarnings("ConstantConditions")
  public MoELifeCycleObserver(@NonNull Context context) {
    Logger.v(TAG + " MoELifeCycleObserver() : ");
    if (context == null) {
      Logger.e(TAG + " MoELifeCycleObserver() : context is null.");
    } else {
      this.context = context.getApplicationContext();
    }
  }

  @OnLifecycleEvent(Event.ON_START)
  public void onStart() {
    Logger.v(TAG + " onStart() : ");
    try {
      MoEngage.isAppForeground = true;
      if (context != null) {
        MoEDispatcher.getInstance(context).onAppOpen();
      }
    } catch (Exception e) {
      Logger.e(TAG + " onStart() : Exception: ", e);
    }
  }

  @OnLifecycleEvent(Event.ON_STOP)
  public void onStop() {
    Logger.v(TAG + " onStop() : ");
    try {
      MoEngage.isAppForeground = false;
      if (context != null) {
        TaskManager.getInstance().addTaskToQueue(new AppCloseTask(context));
      }
    } catch (Exception e) {
      Logger.e(TAG + " onStop() : Exception: ", e);
    }
  }
}
