package com.moengage.core;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.annotation.RestrictTo.Scope;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;

/**
 * @author Arshiya Khanum
 * Date: 2020/08/21
 *
 * @since 10.4.00
 */
@RestrictTo(Scope.LIBRARY)
public class AppCloseTask extends SDKTask {

  private static final String TAG = MoEConstants.MODULE_TAG + "AppCloseTask";

  public AppCloseTask(Context context) {
    super(context);
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : ");
      MoEDispatcher dispatcher = MoEDispatcher.getInstance(context);
      dispatcher.onAppClose();
    } catch (Exception e) {
      Logger.e(TAG + " execute() : Exception: ", e);
    }

    return taskResult;
  }

  @Override public String getTaskTag() {
    return TAG_APP_CLOSE_TASK;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
