/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.logger;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.moengage.core.logger.LogAdapter;
import com.moengage.core.logger.LogUtils;
import com.moengage.core.logger.Printer;
import java.util.ArrayList;
import java.util.List;

public class LogPrinter
implements Printer {
    private List<LogAdapter> logAdapters = new ArrayList<LogAdapter>();
    private String tag = "MoEngage_v10302";

    @Override
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public void addAdapter(@NonNull LogAdapter logAdapter) {
        if (logAdapter != null) {
            this.logAdapters.add(logAdapter);
        }
    }

    @Override
    public void removeAdapter(@NonNull LogAdapter logAdapter) {
        if (logAdapter != null) {
            this.logAdapters.remove(logAdapter);
        }
    }

    @Override
    public void clearAllAdapters() {
        this.logAdapters.clear();
    }

    @Override
    public void v(String message, @Nullable Throwable throwable) {
        this.log(5, this.tag, message, throwable);
    }

    @Override
    public void d(String message, @Nullable Throwable throwable) {
        this.log(4, this.tag, message, throwable);
    }

    @Override
    public void w(String message, @Nullable Throwable throwable) {
        this.log(3, this.tag, message, throwable);
    }

    @Override
    public void e(String message, @Nullable Throwable throwable) {
        this.log(2, this.tag, message, throwable);
    }

    @Override
    public void f(String message, @Nullable Throwable throwable) {
        this.log(1, this.tag, message, throwable);
    }

    @Override
    public void i(String message, @Nullable Throwable throwable) {
        this.log(0, this.tag, message, throwable);
    }

    @Override
    public void log(int logLevel, String tag, String message, @Nullable Throwable throwable) {
        for (LogAdapter logAdapter : this.logAdapters) {
            if (!logAdapter.isLoggable(logLevel, tag)) continue;
            if (throwable != null) {
                message = message + " : " + LogUtils.getStackTraceString(throwable);
            }
            logAdapter.log(logLevel, tag, message);
        }
    }
}

