/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.events;

import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONObject;


/**
 * @author Umang Chamaria
 * Date: 2019-05-28
 */
class EventHandler {

  private static final String TAG = MoEConstants.MODULE_TAG + "EventHandler";

  Event transformToEventModel(String eventName, JSONObject attributes){
    if (attributes != null
        && (attributes.has(MoEHelperUtils.EVENT_ATTRS) || attributes.has(
        MoEHelperUtils.EVENT_ATTRS_CUST))
        && attributes.has(MoEHelperUtils.EVENT_L_TIME)
        && attributes.has(MoEHelperUtils.EVENT_G_TIME)) {
      // payload already built via payload builder directly cast to model
      return new Event(eventName, attributes);
    } else {
      PayloadBuilder payloadBuilder = new PayloadBuilder();
      if (attributes != null) {
        Iterator<String> iterator = attributes.keys();
        while (iterator.hasNext()) {
          try {
            String key = iterator.next();
            payloadBuilder.putAttrObject(key, attributes.get(key));
          } catch (Exception e) {
            Logger.e(TAG + " trackEvent() : Exception ", e);
          }
        }
      }
     return new Event(eventName, payloadBuilder.build());
    }
  }

  /**
   * Checks whether event should be tracked or not.
   *
   * @param isDataTrackingOptedOut data tracking status
   * @param gdprWhitelistEvent list of whitelisted events for gdpr
   * @param blackListEvents list of events which are black listed
   * @param eventName name of the event to be tracked
   * @return true if event should be tracked else false
   */
  boolean shouldTrackEvent(boolean isDataTrackingOptedOut, Set<String> gdprWhitelistEvent,
      Set<String> blackListEvents, String eventName){
    if (isDataTrackingOptedOut){
      if (gdprWhitelistEvent == null) return false;
      return gdprWhitelistEvent.contains(eventName);
    }else {
      if (blackListEvents == null) return true;
      return !blackListEvents.contains(eventName);
    }
  }
}
