/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core;

import android.content.Context;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.Set;
import org.json.JSONObject;

/**
 * Loads configuration shared preference file into the cache.
 *
 * @author Umang Chamaria
 * Date: 2019-06-18
 */
public class LoadConfigurationFromDiskTask extends SDKTask {
  private static final String TAG = MoEConstants.MODULE_TAG + "LoadConfigurationFromDiskTask";

  LoadConfigurationFromDiskTask(Context context) {
    super(context);
  }

  @Override public TaskResult execute() {
    try {
      loadRemoteConfigFromDisk();
    } catch (Exception e) {
      Logger.e( TAG + " execute() : ", e);
    }
    return taskResult;
  }

  private void loadRemoteConfigFromDisk() {
    try {
      String configurationString =
          ConfigurationProvider.getInstance(context).getRemoteConfiguration();
      RemoteConfig configuration = new RemoteConfig();

      if (configurationString != null){
        RemoteConfig storedConfig =
            RemoteConfig.fromJson(new JSONObject(configurationString));
        if (storedConfig != null){
          configuration = storedConfig;
        }
      }
      RemoteConfig.setRemoteConfig(configuration);

      Set<String> savedScreenNames =
          ConfigurationProvider.getInstance(context).getSentScreenNames();
      if (savedScreenNames != null){
        ConfigurationCache.getInstance().initialiseSentScreens(savedScreenNames);
      }
      if (ConfigurationProvider.getInstance(context).isDebugLogEnabled()) {
        SdkConfig.getConfig().isLogEnabledForSignedBuild = true;
        SdkConfig.getConfig().logLevel = Logger.VERBOSE;
      }
      Logger.v(TAG + " loadRemoteConfigFromDisk() : Config: " + RemoteConfig.getConfig().toString());
    } catch (Exception e) {
      Logger.e( TAG + " loadRemoteConfigFromDisk() : Exception ", e);
    }
  }

  @Override public String getTaskTag() {
    return TAG_LOAD_CONFIGURATION_FROM_DISK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

}