/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.executor;

import android.support.annotation.NonNull;
import com.moengage.core.Logger;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.Task;
import com.moengage.core.executor.TaskProcessor;
import java.util.HashSet;
import java.util.Set;

public class TaskManager {
    private static final String TAG = "Core_TaskManager";
    private Set<String> runningTaskList = new HashSet<String>();
    private static TaskManager instance;

    private TaskManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskManager getInstance() {
        if (instance != null) return instance;
        Class<TaskManager> clazz = TaskManager.class;
        synchronized (TaskManager.class) {
            if (instance != null) return instance;
            instance = new TaskManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean addTaskToQueue(@NonNull ITask task) {
        if (task == null) {
            return false;
        }
        Logger.v("Core_TaskManager addTaskToQueue() Trying to add " + task.getTaskTag() + " to the queue");
        if (this.canAddTaskToQueue(task)) {
            Logger.v(task.getTaskTag() + " added to queue");
            this.runningTaskList.add(task.getTaskTag());
            TaskProcessor.getInstance().addTask(task);
            return true;
        }
        Logger.v("Core_TaskManager addTaskToQueue() Task is already queued. Cannot add it to queue. Task : " + task.getTaskTag());
        return false;
    }

    public boolean addTaskToQueueBeginning(@NonNull ITask task) {
        if (task == null) {
            return false;
        }
        Logger.v("Core_TaskManager addTaskToQueueBeginning() Trying to add " + task.getTaskTag() + " to the queue");
        if (this.canAddTaskToQueue(task)) {
            Logger.v("Core_TaskManager addTaskToQueueBeginning() " + task.getTaskTag() + " added to beginning of queue");
            this.runningTaskList.add(task.getTaskTag());
            TaskProcessor.getInstance().addTaskToFront(task);
            return true;
        }
        Logger.v("Core_TaskManager addTaskToQueueBeginning() : Task is already queued. Cannot add it to queue.");
        return false;
    }

    public boolean startTask(@NonNull ITask task) {
        if (task == null) {
            return false;
        }
        Logger.v("Core_TaskManager startTask() : Try to start task " + task.getTaskTag());
        if (this.canAddTaskToQueue(task)) {
            Logger.v("Core_TaskManager Starting task " + task.getTaskTag());
            this.runningTaskList.add(task.getTaskTag());
            TaskProcessor.getInstance().runTask(task);
            return true;
        }
        Logger.v("Core_TaskManager startTask() : Cannot start task. Task is already in progress or queued. " + task.getTaskTag());
        return false;
    }

    public void execute(@NonNull Task task) {
        TaskProcessor.getInstance().execute(task);
    }

    private boolean canAddTaskToQueue(ITask task) {
        if (!task.isSynchronous()) {
            return true;
        }
        return !this.runningTaskList.contains(task.getTaskTag());
    }

    void removeTaskFromList(String tag) {
        Logger.v("Core_TaskManager removeTaskFromList() : Removing tag from list: " + tag);
        this.runningTaskList.remove(tag);
    }
}

