/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.Properties;
import com.moengage.core.RemoteConfig;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.AppStatus;
import java.util.Date;

public class TrackInstallUpdateTask
extends SDKTask {
    private static final String TAG = "TrackInstallUpdateTask";
    private AppStatus appStatus;

    public TrackInstallUpdateTask(Context context, AppStatus appStatus) {
        super(context);
        this.appStatus = appStatus;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("TrackInstallUpdateTask execute() : executing task.");
            if (!RemoteConfig.getConfig().isAppEnabled) {
                return this.taskResult;
            }
            Logger.v("TrackInstallUpdateTask execute() : Tracked App Status: " + (Object)((Object)this.appStatus));
            int currentVersion = ConfigurationProvider.getInstance(this.context).getAppVersion();
            switch (this.appStatus) {
                case UPDATE: {
                    this.trackUpdateEventIfRequired(currentVersion);
                    break;
                }
                case INSTALL: {
                    this.trackInstallEventIfRequired(currentVersion);
                }
            }
            ConfigurationProvider.getInstance(this.context).storeAppVersion(currentVersion);
            Logger.v("TrackInstallUpdateTask execute() : completed task.");
        }
        catch (Exception e) {
            Logger.e("TrackInstallUpdateTask execute() : ", e);
        }
        return this.taskResult;
    }

    private void trackInstallEventIfRequired(int currentVersion) {
        if (ConfigurationProvider.getInstance(this.context).isInstallRegistered()) {
            Logger.e("TrackInstallUpdateTask execute() : Install event is already tracked will not track again.");
            return;
        }
        Logger.v("TrackInstallUpdateTask execute() : Will track install.");
        Properties attributes = new Properties();
        attributes.addAttribute("VERSION", currentVersion).addAttribute("sdk_ver", 10301).addAttribute("INSTALLED_TIME", System.currentTimeMillis()).addAttribute("os", "ANDROID");
        MoEHelper.getInstance(this.context).trackEvent("INSTALL", attributes);
        ConfigurationProvider.getInstance(this.context).setInstallRegistered();
        this.taskResult.setIsSuccess(true);
    }

    private void trackUpdateEventIfRequired(int currentVersion) {
        int prevVersion = ConfigurationProvider.getInstance(this.context).getStoredAppVersion();
        if (currentVersion == prevVersion) {
            Logger.e("TrackInstallUpdateTask trackUpdateEventIfRequired() : Update is already tracked for this version.");
            return;
        }
        Logger.v("TrackInstallUpdateTask trackUpdateEventIfRequired() : Will track update.");
        Properties eventObj = new Properties().addAttribute("VERSION_FROM", prevVersion).addAttribute("VERSION_TO", currentVersion).addAttribute("UPDATED_ON", new Date());
        MoEHelper.getInstance(this.context).trackEvent("UPDATE", eventObj);
        this.taskResult.setIsSuccess(true);
    }

    @Override
    public String getTaskTag() {
        return "INSTALL_UPDATE_TASK";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

