/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEFileManager;
import com.moengage.core.analytics.AnalyticsHelper;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.inapp.InAppManager;
import com.moengage.push.PushManager;

public class LogoutTask
extends SDKTask {
    private static final String TAG = "Core_LogoutTask";

    public LogoutTask(Context context) {
        super(context);
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("Core_LogoutTask execute() : Executing Logout task.");
            InAppManager.getInstance().onLogout(this.context);
            MoEDAO.getInstance(this.context).clearDataOnLogout();
            new MoEFileManager(this.context).clearMoEngageFiles();
            AnalyticsHelper.getInstance(this.context).onLogout(this.context);
            PushManager.getInstance().registerForPush(this.context);
            MoEDispatcher dispatcher = MoEDispatcher.getInstance(this.context);
            dispatcher.getDeviceAddManager().registerDevice(this.context);
            dispatcher.notifyLogoutCompleteListener();
            dispatcher.clearDataOnLogout();
            dispatcher.shouldClearData = false;
            Logger.v("Core_LogoutTask execute() : Completed Logout task");
        }
        catch (Exception e) {
            Logger.e("Core_LogoutTask execute() : ", e);
        }
        return this.taskResult;
    }

    @Override
    public String getTaskTag() {
        return "LOGOUT_TASK";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }
}

