/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import com.moengage.core.DeviceAddTask;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.RemoteConfig;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.TokenState;

public class DeviceAddManager {
    private static final String TAG = "Core_DeviceAddManager";
    private boolean isDeviceAddInProgress;
    private boolean isFcmRegistrationPending;
    private boolean isSecondaryTokenRegistrationPending;
    private boolean isGdprRequestPending;

    public void registerGdprOptOut(Context context) {
        if (this.isDeviceAddInProgress) {
            Logger.v("Core_DeviceAddManager registerGdprOptOut() : Device Add is in progress, will send gdpr opt-out after current request completes.");
            this.isGdprRequestPending = true;
        } else {
            Logger.v("Core_DeviceAddManager registerGdprOptOut() : Initiating request to send GDPR opt out.");
            this.initiateDeviceAdd(context);
        }
    }

    public void registerFcmToken(Context context) {
        if (this.isDeviceAddInProgress) {
            Logger.v("Core_DeviceAddManager registerFcmToken() : Device add in progress will send FCM token to server after current request completes.");
            this.isFcmRegistrationPending = true;
        } else {
            Logger.v("Core_DeviceAddManager registerFcmToken() : Initiating request for sending FCM token to server.");
            this.initiateDeviceAdd(context);
        }
    }

    public void registerOemPushToken(Context context) {
        if (this.isDeviceAddInProgress) {
            Logger.v("Core_DeviceAddManager registerOemPushToken() : Device add is in progress will send token to server after current request is completed");
            this.isSecondaryTokenRegistrationPending = true;
            return;
        }
        Logger.v("Core_DeviceAddManager registerOemPushToken() : Initiating request for sending oem token to server.");
        this.initiateDeviceAdd(context);
    }

    void retryDeviceRegistrationIfRequired(Context context) {
        if (!MoEDAO.getInstance(context).isDeviceRegistered()) {
            Logger.v("Core_DeviceAddManager retryDeviceRegistrationIfRequired() : Device not registered yet. Will try to register device.");
            this.initiateDeviceAdd(context);
        }
    }

    void registerDevice(Context context) {
        if (this.isDeviceAddInProgress) {
            Logger.v("Core_DeviceAddManager registerDevice() : Device add is already in progress, will not make another call.");
            return;
        }
        this.initiateDeviceAdd(context);
    }

    private void initiateDeviceAdd(Context context) {
        Logger.v("Core_DeviceAddManager initiateDeviceAdd() : Will initiate device add call.");
        if (!RemoteConfig.getConfig().isAppEnabled) {
            Logger.e("Core_DeviceAddManager initiateDeviceAdd() : App is disabled. Will not make device add call.");
            return;
        }
        if (!this.isDeviceAddInProgress) {
            Logger.v("Core_DeviceAddManager initiateDeviceAdd() : Initiating device add call");
            MoEDAO.getInstance(context).setDeviceRegistrationState(false);
            this.isDeviceAddInProgress = TaskManager.getInstance().startTask(new DeviceAddTask(context, MoEDAO.getInstance(context).getDevicePreferences()));
            Logger.v("Core_DeviceAddManager initiateDeviceAdd() : Device add call initiated: " + this.isDeviceAddInProgress);
        } else {
            Logger.v("Core_DeviceAddManager initiateDeviceAdd() : Device Add is already in progress cannot schedule another one");
        }
    }

    void processTaskResult(Context context, TaskResult taskResult) {
        try {
            this.isDeviceAddInProgress = false;
            Logger.v("Core_DeviceAddManager processTaskResult() : Device Add completed, processing response.");
            if (taskResult == null) {
                return;
            }
            MoEDAO.getInstance(context).setDeviceRegistrationState(taskResult.isSuccess());
            if (!taskResult.isSuccess()) {
                Logger.v("Core_DeviceAddManager processTaskResult() : Device add failed recently");
                return;
            }
            TokenState tokenState = (TokenState)taskResult.getPayload();
            if (tokenState == null) {
                return;
            }
            if (this.isSecondaryTokenRegistrationPending && !tokenState.isSendingSecondaryToken) {
                this.isSecondaryTokenRegistrationPending = false;
                this.registerOemPushToken(context);
            }
            if (this.isFcmRegistrationPending && !tokenState.isSendingFcmToken) {
                this.isFcmRegistrationPending = false;
                this.registerFcmToken(context);
            }
            if (this.isGdprRequestPending) {
                this.isGdprRequestPending = false;
                this.registerGdprOptOut(context);
            }
        }
        catch (Exception e) {
            Logger.e("Core_DeviceAddManager processTaskResult() : Exception ", e);
        }
    }
}

