/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.DataSyncJob;
import com.moengage.core.Logger;
import com.moengage.core.MoEAlarmReceiver;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;

class ActivityStopTask
extends SDKTask {
    private static final String TAG = "Core_ActivityStopTask";
    private String activityName;
    private int DATA_SYNC_JOB_ID = 99999;

    ActivityStopTask(Context context, String currentActivityName) {
        super(context);
        this.activityName = currentActivityName;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("Core_ActivityStopTask executing task");
            if (!TextUtils.isEmpty((CharSequence)this.activityName)) {
                Logger.v("Core_ActivityStopTask " + this.activityName + " stopped");
            }
            Logger.d("Core_ActivityStopTask activity counter " + MoEHelper.getActivityCounter());
            if (MoEHelper.getActivityCounter() == 0) {
                Logger.v("Core_ActivityStopTask Activity counter zero, will try to send interaction data");
                MoEDispatcher.getInstance(this.context).onAppClose();
                if (Build.VERSION.SDK_INT < 21) {
                    this.scheduleDataSending();
                } else {
                    this.scheduleDataSendingJob();
                }
            }
            Logger.v("Core_ActivityStopTask completed execution");
        }
        catch (Exception e) {
            Logger.e("Core_ActivityStopTask execute() : Exception: ", e);
        }
        return null;
    }

    @Override
    public String getTaskTag() {
        return "ACTIVITY_STOP";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    private void scheduleDataSending() {
        Logger.v("Core_ActivityStopTask scheduleDataSending()");
        Intent alarmIntent = new Intent(this.context, MoEAlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)123, (Intent)alarmIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.set(0, System.currentTimeMillis() + 3000L, pendingIntent);
        }
    }

    @TargetApi(value=21)
    private void scheduleDataSendingJob() {
        Logger.v("Core_ActivityStopTask scheduleDataSendingJob()");
        ComponentName serviceComponent = new ComponentName(this.context, DataSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(this.DATA_SYNC_JOB_ID, serviceComponent);
        builder.setRequiredNetworkType(1);
        builder.setOverrideDeadline(System.currentTimeMillis() + 5000L);
        builder.setMinimumLatency(2000L);
        JobScheduler jobScheduler = (JobScheduler)this.context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.schedule(builder.build());
        }
    }
}

