/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.widget.Toast;
import com.delight.pushlibrary.R;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionManagerBase {
    private static final String TAG = "ActionManagerBase";

    protected void handleActionCopy(Activity context, JSONObject actionObject) throws JSONException {
        Logger.v("ActionManagerBase$handleActionCopy");
        String message = "";
        if (actionObject.has("msg")) {
            message = actionObject.getString("msg");
        }
        if (actionObject.has("value")) {
            String value = actionObject.getString("value");
            MoEHelperUtils.copyTextToClipboardAndShowToast((Context)context, value, message);
        }
    }

    protected void handleActionCall(Activity context, JSONObject actionObject) throws JSONException {
        Logger.v("ActionManagerBase$handleActionCall");
        if (actionObject.has("value")) {
            String phoneNumber = actionObject.getString("value");
            if (!TextUtils.isEmpty((CharSequence)phoneNumber) && this.isPhoneNumberValid(phoneNumber)) {
                this.triggerCallIntent((Context)context, phoneNumber);
            } else {
                Toast.makeText((Context)context, (int)R.string.invalid_number, (int)1).show();
            }
        }
    }

    protected void handleActionShare(Activity context, JSONObject actionObject) throws JSONException {
        Logger.v("ActionManagerBase$handleActionShare");
        if (actionObject.has("content")) {
            String content = actionObject.getString("content");
            this.triggerShareIntent((Context)context, content);
        }
    }

    protected boolean isPhoneNumberValid(String phoneNumber) {
        if (MoEUtils.isEmptyString(phoneNumber)) {
            return false;
        }
        for (int i = 0; i < phoneNumber.length(); ++i) {
            if (PhoneNumberUtils.isDialable((char)phoneNumber.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected void triggerCallIntent(@NonNull Context context, @NonNull String phoneNumber) {
        Intent callIntent = new Intent("android.intent.action.DIAL");
        callIntent.setData(Uri.parse((String)("tel:" + Uri.encode((String)phoneNumber))));
        context.startActivity(callIntent);
    }

    protected void triggerShareIntent(Context context, String content) {
        Intent sharingIntent = new Intent("android.intent.action.SEND");
        sharingIntent.setType("text/plain");
        sharingIntent.putExtra("android.intent.extra.TEXT", content);
        context.startActivity(Intent.createChooser((Intent)sharingIntent, (CharSequence)"Share via"));
    }
}

