package com.moengage.core;

import com.moengage.core.logger.LogAdapter;
import com.moengage.core.logger.LogPrinter;
import com.moengage.core.logger.Printer;

/**
 * Sets the logging level for MoEngage SDK for DEBUG builds only.<br>
 * Log Levels :<br>
 * {@link Logger#VERBOSE} - Prints verbose, debug, warnings, errors and info logs<br>
 * {@link Logger#DEBUG} - Prints debug, warnings, errors and info logs<br>
 * {@link Logger#WARN} - Prints warning, error and info logs.<br>
 * {@link Logger#ERROR} - Prints error and info logs.<br>
 * {@link Logger#INFO} - Prints only info logs.<br>
 * {@link Logger#NO_LOGS} - No logs.<br>
 *
 * @author Umang Chamaria
 * @since 7.0.00
 */
public class Logger {

  /**
   * Priority constant for the println method; use Logger.v.
   */
  public static final int VERBOSE = 5;
  /**
   * Priority constant for the println method; use Logger.d.
   */
  public static final int DEBUG = 4;
  /**
   * Priority constant for the println method; use Logger.w.
   */
  public static final int WARN = 3;
  /**
   * Priority constant for the println method; use Logger.e.
   */
  public static final int ERROR = 2;

  public static final int FATAL = 1;
  /**
   * Priority constant for the println method; use Logger.i.
   */
  public static final int INFO = 0;

  /**
   * Constant for no logs
   */
  public static final int NO_LOGS = -1;

  static int LOG_LEVEL = ERROR;

  //ERROR>WARN>INFO>DEBUG>V - LEVEL
  private Logger() {
  }

  public static void addLogAdapter(LogAdapter logAdapter){
    printer.addAdapter(logAdapter);
  }

  public static void removeLogAdapter(LogAdapter logAdapter){
    printer.removeAdapter(logAdapter);
  }

  public static void setTag(String tag){
    printer.setTag(tag);
  }

  private static Printer printer = new LogPrinter();

  /**
   * @param msg The message you would like logged.
   */
  public static void v(String msg) {
    printer.v(msg, null);
  }

  public static void v(String msg, Throwable tr) {
    printer.v(msg, tr);
  }

  /**
   * @param msg The message you would like logged.
   */
  public static void d(String msg) {
    printer.d(msg, null);
  }

  /**
   * @param msg The message you would like logged.
   * @param tr An exception to log
   */
  public static void d(String msg, Throwable tr) {
    printer.d(msg, tr);
  }

  /**
   * @param msg The message you would like logged.
   */
  public static void i(String msg) {
    printer.i(msg, null);
  }

  /**
   * @param msg The message you would like logged.
   * @param tr An exception to log
   */
  public static void i(String msg, Throwable tr) {
    printer.i(msg, tr);
  }

  /**
   * @param msg The message you would like logged.
   */
  public static void w(String msg) {
    printer.w(msg, null);
  }

  /**
   * @param msg The message you would like logged.
   * @param tr An exception to log
   */
  public static void w(String msg, Throwable tr) {
    printer.w(msg, tr);
  }


  /**
   * @param msg The message you would like logged.
   */
  public static void e(String msg) {
    printer.e(msg, null);
  }

  /**
   * @param msg The message you would like logged.
   * @param tr An exception to log
   */
  public static void e(String msg, Throwable tr) {
    printer.e(msg, tr);
  }

  public static void f(String msg) {
    printer.f(msg, null);
  }

  public static void f(String msg, Throwable tr) {
    printer.f(msg, tr);
  }

  public static void setLogLevel(int logLevel) {
    LOG_LEVEL = logLevel;
  }

  /**
   * Enables DEBUG logs. Should be set to true only in development and
   * testing. Should be set to false when in going live
   */
  static boolean isLoggingEnabled = false;

  public static void enableDebugLog() {
    try {
      isLoggingEnabled = MoEngage.isDebugBuild() || isLoggingEnabled;
    } catch (Exception e) {
      Logger.e("Logger : enableDebugLog", e);
    }
  }
}
