package com.moengage.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.widget.Toast;
import com.delight.pushlibrary.R;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.ActionMapperConstants;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class ActionManagerBase {
  private static final String TAG = "ActionManagerBase";

  protected void handleActionCopy(Activity context, JSONObject actionObject) throws JSONException {
    Logger.v("ActionManagerBase$handleActionCopy");
    String message = "";
    if (actionObject.has(ActionMapperConstants.KEY_MESSAGE)) {
      message = actionObject.getString(ActionMapperConstants.KEY_MESSAGE);
    }
    if (actionObject.has(ActionMapperConstants.KEY_VALUE)) {
      String value = actionObject.getString(ActionMapperConstants.KEY_VALUE);
      MoEHelperUtils.copyTextToClipboardAndShowToast(context, value, message);
    }
  }

  protected void handleActionCall(Activity context, JSONObject actionObject) throws JSONException {
    Logger.v("ActionManagerBase$handleActionCall");
    if (actionObject.has(ActionMapperConstants.KEY_VALUE)) {
      String phoneNumber = actionObject.getString(ActionMapperConstants.KEY_VALUE);
      if (!TextUtils.isEmpty(phoneNumber) && isPhoneNumberValid(phoneNumber)) {
        triggerCallIntent(context, phoneNumber);
      } else {
        Toast.makeText(context, R.string.invalid_number, Toast.LENGTH_LONG).show();
      }
    }
  }

  protected void handleActionShare(Activity context, JSONObject actionObject) throws JSONException {
    Logger.v("ActionManagerBase$handleActionShare");
    if (actionObject.has(ActionMapperConstants.KEY_CONTENT)) {
      String content = actionObject.getString(ActionMapperConstants.KEY_CONTENT);
      triggerShareIntent(context, content);
    }
  }


  protected boolean isPhoneNumberValid(String phoneNumber){
    if (MoEUtils.isEmptyString(phoneNumber)) return false;
    for (int i=0; i<phoneNumber.length(); i++){
      if (!PhoneNumberUtils.isDialable(phoneNumber.charAt(i))) return false;
    }
    return true;
  }

  protected void triggerCallIntent(@NonNull Context context, @NonNull String phoneNumber){
    Intent callIntent = new Intent(Intent.ACTION_DIAL);
    callIntent.setData(Uri.parse("tel:" + Uri.encode(phoneNumber)));
    context.startActivity(callIntent);
  }

  protected void triggerShareIntent(Context context, String content){
    Intent sharingIntent = new Intent(Intent.ACTION_SEND);
    sharingIntent.setType("text/plain");
    sharingIntent.putExtra(Intent.EXTRA_TEXT, content);
    context.startActivity(Intent.createChooser(sharingIntent, "Share via"));
  }
}