/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.support.annotation.NonNull;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEngage;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.integrations.segment.TrackSegmentEventTask;
import com.moengage.core.integrations.segment.TrackSegmentUserAttributeTask;
import com.moengage.core.model.IntegrationMeta;
import com.moengage.push.PushManager;
import java.util.Map;
import org.json.JSONObject;

public class MoEIntegrationHelper {
    private static final String TAG = "Core_MoEIntegrationHelper";

    public static void setIntegrationMeta(@NonNull IntegrationMeta meta) {
        try {
            if (meta == null) {
                return;
            }
            Logger.v("Core_MoEIntegrationHelper setIntegrationMeta() : Meta: " + meta);
            ConfigurationCache.getInstance().setIntegrationType(meta.integrationType);
            ConfigurationCache.getInstance().setIntegrationVersion(meta.integrationVersion);
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper setIntegrationMeta() : ", e);
        }
    }

    public static void trackEventFromSegment(@NonNull Context context, @NonNull String eventName, JSONObject eventAttributes) {
        try {
            if (context == null) {
                return;
            }
            Logger.v("Core_MoEIntegrationHelper trackEventFromSegment() : Event Name: " + eventName);
            Logger.v("Core_MoEIntegrationHelper trackEventFromSegment() : Attributes: " + eventAttributes);
            if (MoEUtils.isEmptyString(eventName)) {
                Logger.e("Core_MoEIntegrationHelper trackEventFromSegment() : Event name cannot be empty");
                return;
            }
            TaskManager.getInstance().addTaskToQueue(new TrackSegmentEventTask(context, eventName, eventAttributes));
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper trackEventFromSegment() : ", e);
        }
    }

    public static void trackUserAttributeFromSegment(@NonNull Context context, Map<String, Object> userAttributesMap) {
        try {
            if (context == null || userAttributesMap == null) {
                return;
            }
            TaskManager.getInstance().addTaskToQueue(new TrackSegmentUserAttributeTask(context, userAttributesMap));
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper trackUserAttributeFromSegment() : ", e);
        }
    }

    public static void initialize(Context context, String appId, String senderId) {
        try {
            Logger.v("Core_MoEIntegrationHelper initialize() : App-id: " + appId);
            Logger.v("Core_MoEIntegrationHelper initialize() : Sender-Id: " + senderId);
            MoEngage.setBuildStatus(MoEUtils.isDebugBuild(context));
            if (MoEUtils.isEmptyString(appId)) {
                return;
            }
            SdkConfig.getConfig().appId = MoEUtils.formatAppId(appId);
            if (!MoEUtils.isEmptyString(senderId)) {
                SdkConfig.getConfig().pushConfig.senderId = senderId;
            }
            if (SdkConfig.getConfig().pushConfig.isFcmPushRegistrationEnabled) {
                PushManager.getInstance().registerForPush(context);
            }
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper initialize() : ", e);
        }
    }

    public static void trackSegmentAnonymousId(@NonNull Context context, String anonymousId) {
        try {
            if (context == null || MoEUtils.isEmptyString(anonymousId)) {
                return;
            }
            ConfigurationProvider.getInstance(context).saveSegmentAnonymousId(anonymousId);
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper trackSegmentAnonymousId() : ", e);
        }
    }
}

