/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.model;

import android.support.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class TrafficSource {
    private static final String TAG = "TrafficSource";
    @Nullable
    public String source;
    @Nullable
    public String medium;
    @Nullable
    public String campaignName;
    @Nullable
    public String campaignId;
    @Nullable
    public String sourceUrl;
    @Nullable
    public String content;
    @Nullable
    public String term;
    public HashMap<String, String> extras;
    private static final String SOURCE = "source";
    private static final String MEDIUM = "medium";
    private static final String CAMPAIGN_NAME = "campaign_name";
    private static final String CAMPAIGN_ID = "campaign_id";
    private static final String SOURCE_URL = "source_url";
    private static final String CONTENT = "content";
    private static final String TERM = "term";
    private static final String EXTRAS = "extras";

    public TrafficSource() {
        this.extras = new HashMap();
    }

    public TrafficSource(@Nullable String source, @Nullable String medium, @Nullable String campaignName, @Nullable String campaignId, @Nullable String content, @Nullable String term) {
        this(source, medium, campaignName, campaignId, content, term, null);
    }

    public TrafficSource(@Nullable String source, @Nullable String medium, @Nullable String campaignName, @Nullable String campaignId, @Nullable String content, @Nullable String term, @Nullable String sourceUrl) {
        this(source, medium, campaignName, campaignId, content, term, sourceUrl, new HashMap<String, String>());
    }

    public TrafficSource(@Nullable String source, @Nullable String medium, @Nullable String campaignName, @Nullable String campaignId, @Nullable String content, @Nullable String term, @Nullable String sourceUrl, HashMap<String, String> extras) {
        this.source = source;
        this.medium = medium;
        this.campaignName = campaignName;
        this.campaignId = campaignId;
        this.content = content;
        this.term = term;
        this.sourceUrl = sourceUrl;
        this.extras = extras;
    }

    @Nullable
    public static JSONObject toJson(TrafficSource source) {
        try {
            if (source == null) {
                return null;
            }
            JSONObject jsonObject = new JSONObject();
            if (source.source != null) {
                jsonObject.put(SOURCE, (Object)source.source);
            }
            if (source.medium != null) {
                jsonObject.put(MEDIUM, (Object)source.medium);
            }
            if (source.campaignName != null) {
                jsonObject.put(CAMPAIGN_NAME, (Object)source.campaignName);
            }
            if (source.campaignId != null) {
                jsonObject.put(CAMPAIGN_ID, (Object)source.campaignId);
            }
            if (source.sourceUrl != null) {
                jsonObject.put(SOURCE_URL, (Object)source.sourceUrl);
            }
            if (source.content != null) {
                jsonObject.put(CONTENT, (Object)source.content);
            }
            if (source.term != null) {
                jsonObject.put(TERM, (Object)source.term);
            }
            JSONObject extrasJson = new JSONObject();
            Set<Map.Entry<String, String>> entrySet = source.extras.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                extrasJson.put(entry.getKey(), (Object)entry.getValue());
            }
            if (extrasJson.length() > 0) {
                jsonObject.put(EXTRAS, (Object)extrasJson);
            }
            return jsonObject;
        }
        catch (Exception e) {
            Logger.e("TrafficSource toJson() : Exception ", e);
            return null;
        }
    }

    public static boolean isEmpty(TrafficSource source) {
        if (source == null) {
            return true;
        }
        return MoEUtils.isEmptyString(source.source) && MoEUtils.isEmptyString(source.medium) && MoEUtils.isEmptyString(source.campaignName) && MoEUtils.isEmptyString(source.campaignId) && MoEUtils.isEmptyString(source.content) && MoEUtils.isEmptyString(source.term) && source.extras.isEmpty();
    }

    @Nullable
    public static TrafficSource fromJson(JSONObject sourceJson) {
        try {
            HashMap<String, String> extras = new HashMap<String, String>();
            if (sourceJson.has(EXTRAS)) {
                JSONObject extrasJson = sourceJson.getJSONObject(EXTRAS);
                Iterator iterator = extrasJson.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String value = extrasJson.getString(key);
                    extras.put(key, value);
                }
            }
            return new TrafficSource(sourceJson.optString(SOURCE, null), sourceJson.optString(MEDIUM, null), sourceJson.optString(CAMPAIGN_NAME, null), sourceJson.optString(CAMPAIGN_ID, null), sourceJson.optString(CONTENT, null), sourceJson.optString(TERM, null), sourceJson.optString(SOURCE_URL, null), extras);
        }
        catch (Exception e) {
            Logger.e("TrafficSource fromJson() : Exception: ", e);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrafficSource source1 = (TrafficSource)o;
        if (this.source != null ? !this.source.equals(source1.source) : source1.source != null) {
            return false;
        }
        if (this.medium != null ? !this.medium.equals(source1.medium) : source1.medium != null) {
            return false;
        }
        if (this.campaignName != null ? !this.campaignName.equals(source1.campaignName) : source1.campaignName != null) {
            return false;
        }
        if (this.campaignId != null ? !this.campaignId.equals(source1.campaignId) : source1.campaignId != null) {
            return false;
        }
        if (this.content != null ? !this.content.equals(source1.content) : source1.content != null) {
            return false;
        }
        if (this.term != null ? !this.term.equals(source1.term) : source1.term != null) {
            return false;
        }
        return this.extras.equals(source1.extras);
    }

    public String toString() {
        return "{source : '" + this.source + '\'' + ", medium : '" + this.medium + '\'' + ", campaignName : '" + this.campaignName + '\'' + ", campaignId : '" + this.campaignId + '\'' + ", sourceUrl : '" + this.sourceUrl + '\'' + ", content : '" + this.content + '\'' + ", term : '" + this.term + '\'' + ", extras : " + this.extras.toString() + '}';
    }
}

