/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moe.pushlibrary.models.GeoLocation;
import com.moe.pushlibrary.models.UserAttribute;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;

public final class ConfigurationProvider {
    private HashMap<String, Object> configMap;
    private boolean initialized = false;
    private static final String PREF_NAME = "pref_moe";
    private static final String CURRENT_APP_VERSION = "APP_VERSION";
    private static final String PREF_KEY_APP_VERSION = "appVersion";
    private static final int NOTIFICATION_ID = 17987;
    private static final String PREF_KEY_LAST_NOTIFICATION_ID = "PREF_LAST_NOTIFICATION_ID";
    private Context context;
    private SharedPreferences preferences;
    private static final String TAG = "Core_ConfigurationProvider";
    private final Object lock = new Object();
    private static ConfigurationProvider instance;
    private final Object gcmTokenLock = new Object();
    private final Object tokenLock = new Object();
    private final Object userLock = new Object();
    private static final String PREF_KEY_APP_UUID_MOE = "APP_UUID";
    public static final String FCM_PUSH_TOKEN = "registration_id";
    static final String PREF_KEY_MOE_ISLAT = "PREF_KEY_MOE_ISLAT";
    private static final String PREF_KEY_MOE_GAID = "PREF_KEY_MOE_GAID";
    private static final String PREF_KEY_INAPP_LAST_SHOWN_TIME = "MOE_LAST_IN_APP_SHOWN_TIME";
    private static final String PREF_KEY_USER_LOCATION = "key_geoinfo";
    private static final String PREF_KEY_NOTIFICATION_SOUND = "key_notification_sound";
    private static final String PREF_LAST_CONFIG_SYNC_TIME = "last_config_sync_time";
    private static final String PREF_LAST_MESSAGE_FETCH_TIME = "last_message_sync";
    private static final String PREF_VERIFICATION_REGISTRATION_TIME = "verfication_registration_time";
    private static final String PREF_HAS_REGISTERED_FOR_VERIFICATION = "has_registered_for_verification";
    private static final String PREF_KEY_ACTIVITY_SENT_LIST = "sent_activity_list";
    private static final String PREF_KEY_ENABLE_DEBUG_LOGS = "enable_logs";
    private static final String PREF_KEY_SEGMENT_ANONYMOUS_ID = "segment_anonymous_id";
    private static final String PREF_KEY_IMMEDIATE_RETRY_SYNC_COUNT = "retry_count";
    private static final String PREF_KEY_DEVICE_TRIGGERS_LAST_SHOW_TIME = "dt_last_show_time";
    private static final String PREF_KEY_DEVICE_TRIGGERS_LAST_SYNC_TIME = "dt_last_sync_time";
    private static final String PREF_KEY_DEVICE_TRIGGERS_MINIMUM_DELAY = "dt_minimum_delay";
    private static final String PREF_KEY_DEVICE_TRIGGERS_DND_START_TIME = "dt_dnd_start";
    private static final String PREF_KEY_DEVICE_TRIGGERS_DND_END_TIME = "dt_dnd_end";
    private static final String DATA_TRACKING_OPT_OUT = "data_tracking_opt_out";
    public static final String PUSH_NOTIFICATION_OPT_OUT = "push_notification_opt_out";
    private static final String IN_APP_NOTIFICATION_OPT_OUT = "in_app_notification_opt_out";
    private static final String PREF_KEY_USER_ATTRIBUTE_UNIQUE_ID = "user_attribute_unique_id";
    private static final String PREF_KEY_LAST_GEO_FENCE_SYNC_TIME = "last_geo_sync_time";
    public static final String OEM_PUSH_TOKEN = "mi_push_token";
    public static final String IS_DEVICE_REGISTERED = "is_device_registered";
    private static String PREF_KEY_USER_SESSION;
    private static final String PREF_KEY_LAST_SYNC_TIME_IN_APP = "inapp_last_sync_time";
    private static final String PREF_KEY_MINIMUM_SYNC_DELAY_IN_APP = "inapp_api_sync_delay";
    private static final String PREF_KEY_GLOBAL_DELAY_IN_APP = "in_app_global_delay";
    private static String PREF_KEY_REMOTE_CONFIGURATION;
    public static final String PREF_KEY_PUSH_SERVICE = "push_service";

    private ConfigurationProvider(Context context) {
        if (context == null) {
            Logger.e("ConfigurationProvider : context passed is null");
            return;
        }
        this.context = context;
        this.preferences = context.getSharedPreferences(PREF_NAME, 0);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            this.configMap = new HashMap();
            try {
                PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
                this.configMap.put(CURRENT_APP_VERSION, packageInfo.versionCode);
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.e("Could not get package name: ", e);
            }
            catch (Exception e) {
                Logger.e("Could not get package name: ", e);
            }
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationProvider getInstance(Context context) {
        Class<ConfigurationProvider> clazz = ConfigurationProvider.class;
        synchronized (ConfigurationProvider.class) {
            if (null == instance) {
                instance = new ConfigurationProvider(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private SharedPreferences getSharedPrefs() {
        if (this.preferences == null) {
            this.preferences = this.context.getSharedPreferences(PREF_NAME, 0);
        }
        return this.preferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFcmToken() {
        Object object = this.gcmTokenLock;
        synchronized (object) {
            return this.getSharedPrefs().getString(FCM_PUSH_TOKEN, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFcmToken(String token) {
        Object object = this.gcmTokenLock;
        synchronized (object) {
            this.getSharedPrefs().edit().putString(FCM_PUSH_TOKEN, token).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken(String tokenName) {
        Object object = this.tokenLock;
        synchronized (object) {
            return this.getSharedPrefs().getString(tokenName, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToken(String tokenName, String token) {
        Object object = this.tokenLock;
        synchronized (object) {
            this.getSharedPrefs().edit().putString(tokenName, token).apply();
        }
    }

    public int getAppVersion() {
        return (Integer)this.configMap.get(CURRENT_APP_VERSION);
    }

    int getStoredAppVersion() {
        return this.getSharedPrefs().getInt(PREF_KEY_APP_VERSION, 0);
    }

    void storeAppVersion(int version) {
        SharedPreferences pref = this.getSharedPrefs();
        pref.edit().putInt(PREF_KEY_APP_VERSION, version).apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentUserId() {
        Object object = this.userLock;
        synchronized (object) {
            String prefUniqueId = this.getSharedPrefs().getString(PREF_KEY_APP_UUID_MOE, null);
            UserAttribute dbUniqueIdObj = MoEDAO.getInstance(this.context).getUserAttributeByName(PREF_KEY_APP_UUID_MOE);
            String dbUniqueId = null;
            if (dbUniqueIdObj != null) {
                dbUniqueId = dbUniqueIdObj.userAttributeValue;
            }
            if (TextUtils.isEmpty((CharSequence)prefUniqueId) && TextUtils.isEmpty((CharSequence)dbUniqueId)) {
                Logger.v("Core_ConfigurationProvider getCurrentUserId() no uniqueId present generating new id");
                return this.generateAndSaveUniqueId();
            }
            if (!TextUtils.isEmpty((CharSequence)dbUniqueId)) {
                Logger.v("Core_ConfigurationProvider getCurrentUserId() unique id present in db");
                this.getSharedPrefs().edit().putString(PREF_KEY_APP_UUID_MOE, dbUniqueId).apply();
                return dbUniqueId;
            }
            if (!TextUtils.isEmpty((CharSequence)prefUniqueId)) {
                Logger.v("Core_ConfigurationProvider getCurrentUserId() unique id present in preference");
                return prefUniqueId;
            }
            Logger.v("Core_ConfigurationProvider getCurrentUserId() generating user id from fallback condition something went wrong");
            return this.generateAndSaveUniqueId();
        }
    }

    public int getNotificationId() {
        return this.getSharedPrefs().getInt(PREF_KEY_LAST_NOTIFICATION_ID, 17987);
    }

    public void updateNotificationId(int notificationId) {
        if (notificationId - 17987 >= 100) {
            notificationId = 17987;
        }
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putInt(PREF_KEY_LAST_NOTIFICATION_ID, notificationId).apply();
    }

    private String generateAndSaveUniqueId() {
        String uid = this.generateUUID();
        UserAttribute uniqueId = new UserAttribute(PREF_KEY_APP_UUID_MOE, uid);
        MoEDAO.getInstance(this.context).addOrUpdateUserAttribute(uniqueId);
        this.getSharedPrefs().edit().putString(PREF_KEY_APP_UUID_MOE, uid).apply();
        return uid;
    }

    private String generateUUID() {
        UUID generatedUID = UUID.randomUUID();
        return generatedUID.toString();
    }

    public void storeGAID(String gaid) {
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putString(PREF_KEY_MOE_GAID, gaid).apply();
    }

    public String getStoredGAID() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getString(PREF_KEY_MOE_GAID, "");
    }

    void storeISLAT(int isLAT) {
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putInt(PREF_KEY_MOE_ISLAT, isLAT).apply();
    }

    int getStoredISLAT() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getInt(PREF_KEY_MOE_ISLAT, 2);
    }

    void removeUserConfigurationOnLogout() {
        this.preferences.edit().remove(PREF_KEY_INAPP_LAST_SHOWN_TIME).remove(PREF_KEY_APP_UUID_MOE).remove(PREF_KEY_DEVICE_TRIGGERS_LAST_SHOW_TIME).remove(PREF_KEY_DEVICE_TRIGGERS_LAST_SYNC_TIME).remove(PREF_KEY_DEVICE_TRIGGERS_MINIMUM_DELAY).remove(PREF_KEY_DEVICE_TRIGGERS_DND_END_TIME).remove(PREF_KEY_DEVICE_TRIGGERS_DND_START_TIME).remove(PREF_KEY_DEVICE_TRIGGERS_MINIMUM_DELAY).remove(PREF_LAST_CONFIG_SYNC_TIME).remove(PREF_KEY_USER_ATTRIBUTE_UNIQUE_ID).remove(IS_DEVICE_REGISTERED).remove(PREF_KEY_LAST_SYNC_TIME_IN_APP).remove(PREF_KEY_USER_SESSION).remove(PREF_KEY_SEGMENT_ANONYMOUS_ID).apply();
    }

    public void saveLocation(GeoLocation location) {
        this.getSharedPrefs().edit().putString(PREF_KEY_USER_LOCATION, location.latitude + "," + location.longitude).apply();
    }

    public GeoLocation getSavedLocation() {
        try {
            String location = this.getSharedPrefs().getString(PREF_KEY_USER_LOCATION, null);
            if (null != location) {
                String[] latLong = location.split(",");
                return new GeoLocation(Double.parseDouble(latLong[0]), Double.parseDouble(latLong[1]));
            }
        }
        catch (Exception e) {
            Logger.e("ConfigurationProvider: getSavedLocation", e);
        }
        return null;
    }

    public String getAppVersionName() {
        if (this.configMap.get("app_version_name") == null) {
            this.setAppVersionName();
        }
        return (String)this.configMap.get("app_version_name");
    }

    private void setAppVersionName() {
        PackageInfo pInfo = null;
        try {
            pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            this.configMap.put("app_version_name", pInfo.versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.e("ConfigurationProvider#setAppVersionName : Package Name not found", e);
        }
    }

    public void saveGeoIDList(String list) {
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putString("geo_list", list).apply();
    }

    public String getGeoIDList() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getString("geo_list", null);
    }

    public void saveNotificationSoundState(boolean state) {
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putBoolean(PREF_KEY_NOTIFICATION_SOUND, state).apply();
    }

    public boolean isNotificationSoundEnabled() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getBoolean(PREF_KEY_NOTIFICATION_SOUND, true);
    }

    public long getLastInAppShownTime() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getLong(PREF_KEY_INAPP_LAST_SHOWN_TIME, 0L);
    }

    public void setLastInAppShownTime(long currentTime) {
        SharedPreferences sp = this.getSharedPrefs();
        sp.edit().putLong(PREF_KEY_INAPP_LAST_SHOWN_TIME, currentTime).apply();
    }

    void setLastConfigSyncTime(long syncTime) {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            sp.edit().putLong(PREF_LAST_CONFIG_SYNC_TIME, syncTime).apply();
        }
    }

    long getLastConfigSyncTime() {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            return sp.getLong(PREF_LAST_CONFIG_SYNC_TIME, 0L);
        }
        return 0L;
    }

    public void setLastPushAmpSyncTime(long time) {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            sp.edit().putLong(PREF_LAST_MESSAGE_FETCH_TIME, time).apply();
        }
    }

    public long getLastPushAmpSyncTime() {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            return sp.getLong(PREF_LAST_MESSAGE_FETCH_TIME, 0L);
        }
        return 0L;
    }

    public void setVerificationRegistrationTime(long time) {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            sp.edit().putLong(PREF_VERIFICATION_REGISTRATION_TIME, time).apply();
        }
    }

    public long getVerificationRegistrationTime() {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            return sp.getLong(PREF_VERIFICATION_REGISTRATION_TIME, 0L);
        }
        return 0L;
    }

    public void setVerificationRegistration(boolean hasVerificationRegistered) {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            sp.edit().putBoolean(PREF_HAS_REGISTERED_FOR_VERIFICATION, hasVerificationRegistered).apply();
        }
    }

    public boolean isDeviceRegisteredForVerification() {
        SharedPreferences sp = this.getSharedPrefs();
        if (sp != null) {
            return sp.getBoolean(PREF_HAS_REGISTERED_FOR_VERIFICATION, false);
        }
        return false;
    }

    void saveSentScreenNames(Set<String> sentScreenNames) {
        SharedPreferences.Editor editor = this.getSharedPrefs().edit();
        editor.putStringSet(PREF_KEY_ACTIVITY_SENT_LIST, sentScreenNames).apply();
    }

    Set<String> getSentScreenNames() {
        return this.getSharedPrefs().getStringSet(PREF_KEY_ACTIVITY_SENT_LIST, null);
    }

    public void setDebugLogStatus(boolean status) {
        SharedPreferences.Editor editor = this.getSharedPrefs().edit();
        editor.putBoolean(PREF_KEY_ENABLE_DEBUG_LOGS, status).apply();
    }

    boolean isDebugLogEnabled() {
        SharedPreferences sp = this.getSharedPrefs();
        return sp.getBoolean(PREF_KEY_ENABLE_DEBUG_LOGS, false);
    }

    public void saveSegmentAnonymousId(String anonymousId) {
        this.getSharedPrefs().edit().putString(PREF_KEY_SEGMENT_ANONYMOUS_ID, anonymousId).apply();
    }

    @Nullable
    public String getSegmentAnonymousId() {
        return this.getSharedPrefs().getString(PREF_KEY_SEGMENT_ANONYMOUS_ID, null);
    }

    void setImmediateRetryCount(int count) {
        this.getSharedPrefs().edit().putInt(PREF_KEY_IMMEDIATE_RETRY_SYNC_COUNT, count).apply();
    }

    int getImmediateRetryCount() {
        return this.getSharedPrefs().getInt(PREF_KEY_IMMEDIATE_RETRY_SYNC_COUNT, 0);
    }

    public void saveLastDTShowTime(long time) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_DEVICE_TRIGGERS_LAST_SHOW_TIME, time).apply();
    }

    public long getDTLastShowTime() {
        return this.getSharedPrefs().getLong(PREF_KEY_DEVICE_TRIGGERS_LAST_SHOW_TIME, 0L);
    }

    public void saveLastDTSyncTime(long time) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_DEVICE_TRIGGERS_LAST_SYNC_TIME, time).apply();
    }

    public long getDTLastSyncTime() {
        return this.getSharedPrefs().getLong(PREF_KEY_DEVICE_TRIGGERS_LAST_SYNC_TIME, 0L);
    }

    public void saveDTMinimumDelay(long time) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_DEVICE_TRIGGERS_MINIMUM_DELAY, time).apply();
    }

    public long getDTMinimumDelay() {
        return this.getSharedPrefs().getLong(PREF_KEY_DEVICE_TRIGGERS_MINIMUM_DELAY, 0L);
    }

    public void saveDTDNDStartTime(long time) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_DEVICE_TRIGGERS_DND_START_TIME, time).apply();
    }

    public long getDTDNDStartTime() {
        return this.getSharedPrefs().getLong(PREF_KEY_DEVICE_TRIGGERS_DND_START_TIME, -1L);
    }

    public void saveDNDEndTime(long time) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_DEVICE_TRIGGERS_DND_END_TIME, time).apply();
    }

    public long getDNDEndTime() {
        return this.getSharedPrefs().getLong(PREF_KEY_DEVICE_TRIGGERS_DND_END_TIME, -1L);
    }

    void optOutOfDataTracking(boolean optOut) {
        this.getSharedPrefs().edit().putBoolean(DATA_TRACKING_OPT_OUT, optOut).apply();
    }

    public boolean isDataTrackingOptedOut() {
        return this.getSharedPrefs().getBoolean(DATA_TRACKING_OPT_OUT, false);
    }

    void optOutOfPushNotification(boolean optOut) {
        this.getSharedPrefs().edit().putBoolean(PUSH_NOTIFICATION_OPT_OUT, optOut).apply();
    }

    public boolean isPushNotificationOptedOut() {
        return this.getSharedPrefs().getBoolean(PUSH_NOTIFICATION_OPT_OUT, false);
    }

    void optOutOfInAppNotification(boolean optOut) {
        this.getSharedPrefs().edit().putBoolean(IN_APP_NOTIFICATION_OPT_OUT, optOut).apply();
    }

    public boolean isInAppOptedOut() {
        return this.getSharedPrefs().getBoolean(IN_APP_NOTIFICATION_OPT_OUT, false);
    }

    public void saveUserAttributeUniqueId(String uniqueId) {
        this.getSharedPrefs().edit().putString(PREF_KEY_USER_ATTRIBUTE_UNIQUE_ID, uniqueId).commit();
    }

    public String getUserAttributeUniqueId() {
        return this.getSharedPrefs().getString(PREF_KEY_USER_ATTRIBUTE_UNIQUE_ID, null);
    }

    public void setLastGeoFenceSyncTime(long time) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_LAST_GEO_FENCE_SYNC_TIME, time).apply();
    }

    public long getLastGeoFenceSyncTime() {
        return this.getSharedPrefs().getLong(PREF_KEY_LAST_GEO_FENCE_SYNC_TIME, 0L);
    }

    void clearPushToken() {
        this.removeKey(FCM_PUSH_TOKEN);
        this.removeKey(OEM_PUSH_TOKEN);
    }

    public void saveUserSession(String sessionString) {
        this.getSharedPrefs().edit().putString(PREF_KEY_USER_SESSION, sessionString).apply();
    }

    String getUserSession() {
        return this.getSharedPrefs().getString(PREF_KEY_USER_SESSION, null);
    }

    public void saveLastInAppSyncTime(long nextSyncTime) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_LAST_SYNC_TIME_IN_APP, nextSyncTime).apply();
    }

    public long getLastInAppSyncTime() {
        return this.getSharedPrefs().getLong(PREF_KEY_LAST_SYNC_TIME_IN_APP, 0L);
    }

    public void saveInAppApiSyncDelay(long minimumSyncDelay) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_MINIMUM_SYNC_DELAY_IN_APP, minimumSyncDelay).apply();
    }

    public long getInAppApiSyncDelay() {
        return this.getSharedPrefs().getLong(PREF_KEY_MINIMUM_SYNC_DELAY_IN_APP, 900L);
    }

    public void saveInAppGlobalDelay(long globalDelay) {
        this.getSharedPrefs().edit().putLong(PREF_KEY_GLOBAL_DELAY_IN_APP, globalDelay).apply();
    }

    public long getInAppGlobalDelay() {
        return this.getSharedPrefs().getLong(PREF_KEY_GLOBAL_DELAY_IN_APP, 900L);
    }

    public void setRemoteConfiguration(String configurationString) {
        this.getSharedPrefs().edit().putString(PREF_KEY_REMOTE_CONFIGURATION, configurationString).apply();
    }

    public String getRemoteConfiguration() {
        return this.getSharedPrefs().getString(PREF_KEY_REMOTE_CONFIGURATION, null);
    }

    public void setInstallRegistered() {
        this.getSharedPrefs().edit().putBoolean("pref_installed", true).apply();
    }

    boolean isInstallRegistered() {
        return this.getSharedPrefs().getBoolean("pref_installed", false);
    }

    public void savePushService(String service) {
        this.getSharedPrefs().edit().putString(PREF_KEY_PUSH_SERVICE, service).apply();
    }

    public String getPushService() {
        return this.getSharedPrefs().getString(PREF_KEY_PUSH_SERVICE, "FCM");
    }

    public void putString(String key, String value) {
        this.preferences.edit().putString(key, value).apply();
    }

    public String getString(String key, String defaultValue) {
        return this.preferences.getString(key, defaultValue);
    }

    public void putInt(String key, int value) {
        this.preferences.edit().putInt(key, value).apply();
    }

    public int getInt(String key, int defaultValue) {
        return this.preferences.getInt(key, defaultValue);
    }

    public void putLong(String key, long value) {
        this.preferences.edit().putLong(key, value).apply();
    }

    public long getLong(String key, long defaultValue) {
        return this.preferences.getLong(key, defaultValue);
    }

    public void putBoolean(String key, boolean value) {
        this.preferences.edit().putBoolean(key, value).apply();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.preferences.getBoolean(key, defaultValue);
    }

    public void putStringSet(String key, Set<String> stringSet) {
        this.preferences.edit().putStringSet(key, stringSet).apply();
    }

    public Set<String> getStringSet(String key, Set<String> defaultValue) {
        return this.preferences.getStringSet(key, defaultValue);
    }

    public void removeKey(String key) {
        this.preferences.edit().remove(key).apply();
    }

    static {
        PREF_KEY_USER_SESSION = "user_session";
        PREF_KEY_REMOTE_CONFIGURATION = "remote_configuration";
    }
}

