/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.MoEAttribute;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */

class SetAliasTask extends SDKTask{

  private static final String TAG = MoEConstants.MODULE_TAG + "SetAliasTask";

  private JSONObject aliasJSON;

  SetAliasTask(Context context, JSONObject aliasJSON){
    super(context);
    this.aliasJSON = aliasJSON;
  }

  @Override public TaskResult execute(){
    try{
      Logger.v("SetAliasTask: executing alias task");
      MoEAttribute aliasAttribute = MoEUtils.convertJsonToAttributeObject(aliasJSON);
      String savedUniqueId = MoEUtils.getUserAttributeUniqueId(context);
      if (savedUniqueId == null || aliasAttribute == null){
        MoEDispatcher.getInstance(context).getAttributeManager().setUserAttribute(aliasJSON);
        return null;
      }
      if (savedUniqueId.equals(aliasAttribute.getValue())){
        Logger.v(TAG + " execute() current unique id same as same existing no need to "
            + "update");
        return null;
      }
      if (!MoEDispatcher.getInstance(context)
          .getCoreEvaluator()
          .isValidUniqueId(RemoteConfig.getConfig().blockedUniqueIdRegex,
              aliasAttribute.getValue())) {
        Logger.e(TAG
            + " execute() : Not a valid unique id. Tracked Value: "
            + aliasAttribute.getValue());
        return null;
      }
      MoEDAO.getInstance(context).saveUserAttributeUniqueId(aliasAttribute);
      aliasJSON.put(MoEHelperConstants.USER_ID_MODIFIED_FROM, savedUniqueId);
      Event event = new Event(MoEConstants.EVENT_ACTION_USER_ATTRIBUTE, aliasJSON);
      MoEEventManager.getInstance(context).writeDataPointToStorage(event);
      Logger.v(TAG + " completed alias task");
    } catch(Exception e){
      Logger.v(TAG + " execute() ", e);
    }
    return null;
  }

  @Override public String getTaskTag(){
    return TAG_SET_ALIAS;
  }

  @Override public boolean isSynchronous(){
    return true;
  }
}
