/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moe.pushlibrary.utils;

import com.delight.pushlibrary.BuildConfig;

/**
 * A class containing all the Helper constants which the client app might need
 * to use.
 *
 * @author MoEngage (abhishek@moengage.com)
 * @version 5.2.0
 * @since 1.0
 */
public final class MoEHelperConstants {

  private MoEHelperConstants() {
    // Utility class contains only constants cannot be instantiated by dev
  }

  /**
   * The current lib version. If lib version is v5.0.0 then the value is 500
   */
  public static final int LIB_VERSION = BuildConfig.MOENGAGE_SDK_VERSION;
  /**
   * The User attribute name that denotes a unique attribute
   */
  public static final String USER_ATTRIBUTE_UNIQUE_ID = "USER_ATTRIBUTE_UNIQUE_ID";
  /**
   * The User attribute name which denotes the user email id
   */
  public static final String USER_ATTRIBUTE_USER_EMAIL = "USER_ATTRIBUTE_USER_EMAIL";
  /**
   * The User attribute name which denotes the user mobile number
   */
  public static final String USER_ATTRIBUTE_USER_MOBILE = "USER_ATTRIBUTE_USER_MOBILE";
  /**
   * The User attribute name which denotes the user name
   */
  public static final String USER_ATTRIBUTE_USER_NAME = "USER_ATTRIBUTE_USER_NAME";
  /**
   * The User attribute name which denotes the user gender
   */
  public static final String USER_ATTRIBUTE_USER_GENDER = "USER_ATTRIBUTE_USER_GENDER";
  /**
   * The User attribute name which denotes the user first name
   */
  public static final String USER_ATTRIBUTE_USER_FIRST_NAME = "USER_ATTRIBUTE_USER_FIRST_NAME";
  /**
   * The User attribute name which denotes the last name of the user
   */
  public static final String USER_ATTRIBUTE_USER_LAST_NAME = "USER_ATTRIBUTE_USER_LAST_NAME";

  public static final String USER_ATTRIBUTE_USER_LOCATION = "last_known_location";
  /**
   * The User attribute name which denotes the user birth date
   */
  public static final String USER_ATTRIBUTE_USER_BDAY = "USER_ATTRIBUTE_USER_BDAY";

  /**
   * The User attribute value associated with
   * {@link #USER_ATTRIBUTE_USER_GENDER} representing a MALE user
   */
  public static final String GENDER_MALE = "male";
  /**
   * The User attribute value associated with
   * {@link #USER_ATTRIBUTE_USER_GENDER} representing a FEMALE user
   */
  public static final String GENDER_FEMALE = "female";
  /**
   * The GCM intent extra key which denotes that GCM payload was received from
   * MoEngage
   */
  public static final String GCM_EXTRA_CONFIRMATION_KEY = "push_from";
  /**
   * The GCM intent extra value which denotes that GCM payload was received
   * from MoEngage
   */
  public static final String GCM_EXTRA_CONFIRMATION_VALUE = "moengage";

    /* ***************************** GCM PAYLOAD KEYs ************************************** */
  /**
   * Associated with the GCM Payload received from the MoEngage Platform.
   */
  public static final String GCM_EXTRA_UNIQUE_ID = "gcm_uniqueId";
  /**
   * Associated with the GCM Payload received from the MoEngage Platform.
   * Denotes that a dialog needs to be shown
   */
  public static final String GCM_EXTRA_SHOW_DIALOG = "gcm_show_dialog";
  /**
   * Associated with the GCM Payload. The notification title.
   */
  public static final String GCM_EXTRA_TITLE = "gcm_title";
  /**
   * Associated with the GCM Payload. The notification body
   */
  public static final String GCM_EXTRA_CONTENT = "gcm_alert";
  /**
   * Associated with the GCM Payload. An action to a notification.
   */
  public static final String GCM_EXTRA_ACTION = "gcm_action_title";
  /**
   * Associated with the GCM Payload. The Activity to open on notification
   * click
   */
  public static final String GCM_EXTRA_ACTIVITY_NAME = "gcm_activityName";
  /**
   * Associated with the GCM Payload. Denotes that the Notification opens a
   * web URL in a browser
   */
  public static final String GCM_EXTRA_WEB_NOTIFICATION = "gcm_webNotification";
  /**
   * Associated with the GCM Payload. Denotes the kind of notification we need
   * to show. Its Either {@link #GCM_EXTRA_WEB_NOTIFICATION},
   */
  public static final String NOTIFICATION_TYPE = "gcm_notificationType";
  /**
   * Associated with the GCM Payload. The URL to open for a
   * {@link #GCM_EXTRA_WEB_NOTIFICATION}
   */
  public static final String GCM_EXTRA_WEB_URL = "gcm_webUrl";
  /**
   * Associated with the GCM Payload. The campaign ID associated to this push
   * notification
   */
  public static final String GCM_EXTRA_CAMPAIGN_ID = "gcm_campaign_id";
  /**
   * Associated with the GCM Payload. The Geo ID associated to this user
   */
  public static final String GCM_EXTRA_GEO_ID = "gcm_geo_id";
  /**
   * Associated with the GCM Payload. The coupon code that the payload
   * contains.
   */
  public static final String GCM_EXTRA_COUPON_CODE = "gcm_coupon_code";
  /**
   * Associated with the GCM Payload. The Image that the notification has to
   * show
   */
  public static final String GCM_EXTRA_IMAGE_URL = "gcm_image_url";
  /**
   * An <B>intent extra</b> which is used to denote that the launched activity
   * was shown as a result of a notification getting clicked. It is also
   * associated with <b>event tracking</b> telling the server that a
   * notification was received and to increment the impression count
   */
  public static final String NOTIFICATION_RECEIVED_MOE = "NOTIFICATION_RECEIVED_MOE";
  /**
   * Associated with event tracking for notification being clicked
   */
  public static final String EVENT_NOTIFICATION_CLICKED = "NOTIFICATION_CLICKED_MOE";

  public static final String EVENT_APP_UPDATE = "UPDATE";

  public static final String EVENT_APP_INSTALL = "INSTALL";

  public static final String FROM_VERSION = "VERSION_FROM";

  public static final String TO_VERSION = "VERSION_TO";

  public static final String VERSION = "VERSION";

  public static final String TIME_OF_INSTALL = "INSTALLED_TIME";

  public static final String TIME_OF_UPDATE = "UPDATED_ON";

  public static final String EXTRA_IS_FROM_BACKGROUND = "FROM_BACKGROUND";

  /**
   * The Intent extra which tells the system when the notification was
   * received from the server
   */
  public static final String EXTRA_MSG_RECEIVED_TIME = "MOE_MSG_RECEIVED_TIME";

  public static final String EXTRA_CAMPAIGN_EXPIRED = "gcm_campaign_expired";

  /**
   * Delimiter for events in the list.
   */
  public static final String EVENT_SEPERATOR = ";";

  public static final String PREF_KEY_GEO_FENCE_LIST = "geo_list";

  public static final String USER_ID_MODIFIED_FROM = "USER_ID_MODIFIED_FROM";

  public static final String USER_ATTRIBUTE_USER_PUSH_PREFERENCE = "USER_PUSH_PREFERENCE";

  public static String EVENT_GEO_FENCE_HIT = "MOE_GEOFENCE_HIT";

  public static String NOTIFICATION_OFFLINE_MOE = "NOTIFICATION_OFFLINE_MOE";

  public static String DT_CAMPAIGN_SCHEDULED = "DT_CAMPAIGN_SCHEDULED";

  /**
   * Rating event
   */
  public static String APP_RATED_EVENT = "MOE_APP_RATED";

  public static final String TOKEN_EVENT = "TOKEN_EVENT";

  public static final String USER_ATTRIBUTE_SEGMENT_ID = "USER_ATTRIBUTE_SEGMENT_ID";

  public static final String MOE_WEB_URL = "moe_webUrl";

  public static final String NOTIFICATION_TYPE_NORMAL_NOTIFICATION = "normal notification";
}
