/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.utils;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.rest.Response;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;

public class ApiUtility {
    private static final String TAG = "ApiUtility";

    @Nullable
    public static List<String> jsonArrayToStringList(JSONArray jsonArray) {
        try {
            if (jsonArray == null) {
                return null;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                String s = jsonArray.getString(i);
                if (TextUtils.isEmpty((CharSequence)s)) continue;
                stringList.add(s);
            }
            return stringList;
        }
        catch (Exception e) {
            Logger.e("ApiUtility jsonArrayToStringList() : Exception ", e);
            return null;
        }
    }

    public static boolean isSuccessfulResponse(Response response) {
        if (response == null) {
            return false;
        }
        return response.responseCode == 200;
    }

    public static Set<String> jsonArrayToStringSet(JSONArray jsonArray) {
        HashSet<String> stringSet = new HashSet<String>();
        try {
            if (jsonArray == null) {
                return stringSet;
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                if (MoEUtils.isEmptyString(jsonArray.getString(i))) continue;
                stringSet.add(jsonArray.getString(i));
            }
            return stringSet;
        }
        catch (Exception e) {
            Logger.e("ApiUtility jsonArrayToStringSet() : Exception: ", e);
            return stringSet;
        }
    }

    public static <T> JSONArray listToJsonArray(List<T> list) {
        JSONArray jsonArray = new JSONArray();
        for (T item : list) {
            jsonArray.put(item);
        }
        return jsonArray;
    }

    public static <T> JSONArray setToJsonArray(Set<T> set) {
        JSONArray jsonArray = new JSONArray();
        for (T item : set) {
            jsonArray.put(item);
        }
        return jsonArray;
    }
}

