/*
 * Decompiled with CFR 0.152.
 */
package com.moe.pushlibrary;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.location.Location;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEActivityLifeCycleCallBacks;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.Logger;
import com.moengage.core.MoECallbacks;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.core.RemoteConfig;
import com.moengage.core.TrackInstallUpdateTask;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.inapp.InAppManager;
import com.moengage.core.integrations.segment.TrackSegmentEventTask;
import com.moengage.core.integrations.segment.TrackSegmentUserAttributeTask;
import com.moengage.core.listeners.OnAppBackgroundListener;
import com.moengage.core.listeners.OnLogoutCompleteListener;
import com.moengage.core.model.AppStatus;
import com.moengage.core.model.UserGender;
import com.moengage.core.userattributes.MoEAttributeManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class MoEHelper {
    private MoEDispatcher dispatcher = null;
    private String BUNDLE_EXTRA_RESTORING = "EXTRA_RESTORING";
    private boolean isActivityBeingRestored = false;
    private Context context;
    private static int activityCounter = 0;
    private static String TAG = "Core_MoEHelper";
    private boolean isFirstScreen;
    private MoEAttributeManager attributeManager = null;
    private static MoEHelper instance = null;
    private MoEActivityLifeCycleCallBacks lifeCycleCallBacks;
    private Application application;
    private List<String> appContext;

    public static int getActivityCounter() {
        return activityCounter;
    }

    private static synchronized void incrementCounter() {
        ++activityCounter;
    }

    private static synchronized void decrementCounter() {
        --activityCounter;
    }

    public static boolean isAppInForeground() {
        return activityCounter > 0;
    }

    private MoEHelper(Context con) {
        this.context = con.getApplicationContext();
        if (null == this.dispatcher) {
            this.dispatcher = this.getDelegate();
        }
        this.attributeManager = this.getAttributeManager();
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoEHelper getInstance(@NonNull Context context) {
        if (instance != null) return instance;
        Class<MoEHelper> clazz = MoEHelper.class;
        synchronized (MoEHelper.class) {
            if (instance != null) return instance;
            instance = new MoEHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void initialize(String senderId, String appId) {
        this.dispatcher.initialize(senderId, appId);
    }

    public void onNewIntent(Activity activity, Intent intent) {
        if (!this.isActivityBeingRestored) {
            this.dispatcher.onStart(activity, intent);
        }
        InAppManager.getInstance().registerInAppManager(activity);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onStartInternal(@NonNull Activity activity) {
        if (MoEHelper.getActivityCounter() == 0) {
            this.dispatcher.onAppOpen();
            this.setFirstScreen(true);
        }
        MoEHelper.incrementCounter();
        this.context = activity.getApplicationContext();
        this.onNewIntent(activity, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onStopInternal(@NonNull Activity activity) {
        Logger.v("Activity onStop called for " + activity.toString());
        MoEHelper.decrementCounter();
        InAppManager.getInstance().unregisterInAppManager(activity);
        this.dispatcher.onStop(activity);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onResumeInternal(Activity activity) {
        if (null == this.context) {
            this.context = activity.getApplicationContext();
        }
        Logger.v("Activity onResume called for " + activity.toString());
        this.dispatcher.onResume(activity, this.isActivityBeingRestored);
        this.isActivityBeingRestored = false;
    }

    public void onSaveInstanceState(Bundle outState) {
        Logger.v(TAG + " onSaveInstanceState-- saving state");
        if (null == outState) {
            return;
        }
        outState.putBoolean(this.BUNDLE_EXTRA_RESTORING, true);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        Logger.v(TAG + " onRestoreInstanceState-- restoring state");
        if (null == savedInstanceState) {
            return;
        }
        if (savedInstanceState.containsKey(this.BUNDLE_EXTRA_RESTORING)) {
            this.isActivityBeingRestored = true;
            savedInstanceState.remove(this.BUNDLE_EXTRA_RESTORING);
        }
    }

    @Deprecated
    public MoEHelper trackEvent(@NonNull String action, JSONObject attrs) {
        if (TextUtils.isEmpty((CharSequence)action)) {
            return this;
        }
        MoEEventManager.getInstance(this.context).trackEvent(action, attrs);
        return this;
    }

    @Deprecated
    public MoEHelper trackEvent(@NonNull String action, @NonNull Map<String, String> attrs) {
        Set<String> keySet = attrs.keySet();
        if (keySet.isEmpty()) {
            return this;
        }
        PayloadBuilder newAttrs = new PayloadBuilder();
        for (String key : keySet) {
            try {
                newAttrs.putAttrString(key, attrs.get(key));
            }
            catch (Exception e) {
                Logger.e(TAG + " trackEvent", e);
            }
        }
        this.trackEvent(action, newAttrs);
        return this;
    }

    @Deprecated
    public MoEHelper trackEvent(@NonNull String action) {
        if (TextUtils.isEmpty((CharSequence)action)) {
            return this;
        }
        this.trackEvent(action.trim(), new PayloadBuilder());
        return this;
    }

    @Deprecated
    public MoEHelper trackEvent(@NonNull String action, PayloadBuilder payloadBuilder) {
        if (TextUtils.isEmpty((CharSequence)action)) {
            Logger.e(TAG + " trackEvent() : Action name cannot be null");
            return this;
        }
        if (payloadBuilder == null) {
            payloadBuilder = new PayloadBuilder();
        } else {
            MoEEventManager.getInstance(this.context).trackEvent(action, payloadBuilder);
        }
        return this;
    }

    public void trackEvent(@NonNull String eventName, Properties properties) {
        if (MoEUtils.isEmptyString(eventName)) {
            return;
        }
        if (properties == null) {
            properties = new Properties();
        }
        MoEEventManager.getInstance(this.context).trackEvent(eventName, properties.getPayload());
    }

    public MoEHelper setUserAttribute(@NonNull String userAttribute, @NonNull String attributeValue) {
        if (userAttribute == null) {
            Logger.e(TAG + " User attribute value cannot be null");
            return this;
        }
        try {
            if (attributeValue == null) {
                attributeValue = "";
            } else if ("USER_ATTRIBUTE_USER_BDAY".equals(userAttribute)) {
                attributeValue = URLEncoder.encode(attributeValue, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e1) {
            Logger.e(TAG + " setUserAttribute", e1);
        }
        catch (Exception e) {
            Logger.e(TAG + " setUserAttribute", e);
        }
        JSONObject userJson = new JSONObject();
        try {
            userJson.put(userAttribute.trim(), (Object)attributeValue);
            this.attributeManager.setUserAttribute(userJson);
        }
        catch (Exception e) {
            Logger.e(TAG + " setUserAttribute", e);
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String userAttribute, int attributeValue) {
        if (userAttribute == null) {
            Logger.e(TAG + " User attribute value cannot be null");
            return this;
        }
        JSONObject userJson = new JSONObject();
        try {
            userJson.put(userAttribute.trim(), attributeValue);
            this.attributeManager.setUserAttribute(userJson);
        }
        catch (Exception e) {
            Logger.e(TAG + " setUserAttribute", e);
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String userAttribute, boolean attributeValue) {
        if (userAttribute == null) {
            Logger.e(TAG + " User attribute value cannot be null");
            return this;
        }
        JSONObject userJson = new JSONObject();
        try {
            userJson.put(userAttribute.trim(), attributeValue);
            this.attributeManager.setUserAttribute(userJson);
        }
        catch (Exception e) {
            Logger.e(TAG + " setUserAttribute", e);
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String userAttribute, double attributeValue) {
        if (userAttribute == null) {
            Logger.e(TAG + " User attribute value cannot be null");
            return this;
        }
        JSONObject userJson = new JSONObject();
        try {
            userJson.put(userAttribute.trim(), attributeValue);
            this.attributeManager.setUserAttribute(userJson);
        }
        catch (Exception e) {
            Logger.e(TAG + " setUserAttribute", e);
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String userAttribute, float attributeValue) {
        if (userAttribute == null) {
            Logger.e(TAG + " User attribute value cannot be null");
            return this;
        }
        JSONObject userJson = new JSONObject();
        try {
            userJson.put(userAttribute.trim(), (double)attributeValue);
            this.attributeManager.setUserAttribute(userJson);
        }
        catch (Exception e) {
            Logger.e(TAG + " setUserAttribute", e);
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String userAttribute, long attributeValue) {
        if (userAttribute == null) {
            Logger.e(TAG + " User attribute value cannot be null");
            return this;
        }
        JSONObject userJson = new JSONObject();
        try {
            userJson.put(userAttribute.trim(), attributeValue);
            this.attributeManager.setUserAttribute(userJson);
        }
        catch (Exception e) {
            Logger.e(TAG + " setUserAttribute", e);
        }
        return this;
    }

    public MoEHelper setUserAttributeEpochTime(@NonNull String userAttribute, long attributeValue) {
        if (userAttribute == null) {
            Logger.e(TAG + " User attribute value cannot be null");
            return this;
        }
        this.attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrDateEpoch(userAttribute, attributeValue).build());
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull Map<String, Object> attributeMap) {
        if (attributeMap.isEmpty()) {
            Logger.e(TAG + " User attribute map cannot be null or empty");
            return this;
        }
        Set<String> keySet = attributeMap.keySet();
        if (keySet.isEmpty()) {
            return this;
        }
        for (String key : keySet) {
            try {
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                Object attrValue = attributeMap.get(key);
                if (attrValue instanceof Date) {
                    this.setUserAttribute(key.trim(), (Date)attrValue);
                    continue;
                }
                if (attrValue instanceof GeoLocation) {
                    this.setUserAttribute(key.trim(), (GeoLocation)attrValue);
                    continue;
                }
                if (attrValue instanceof Location) {
                    this.setUserAttribute(key.trim(), (Location)attrValue);
                    continue;
                }
                JSONObject userJson = new JSONObject();
                userJson.put(key.trim(), attrValue);
                this.attributeManager.setUserAttribute(userJson);
            }
            catch (Exception e) {
                Logger.e(TAG + " setUserAttribute", e);
            }
        }
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String name, @NonNull Date value) {
        if (MoEUtils.isEmptyString(name)) {
            Logger.e(TAG + " User attribute value cannot be null");
            return this;
        }
        this.attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrDate(name, value).build());
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String name, @NonNull String date, String dateFormat) {
        if (MoEUtils.isEmptyString(name)) {
            Logger.e(TAG + " User attribute value cannot be null");
            return this;
        }
        this.attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrDate(name, date, dateFormat).build());
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String name, @NonNull Location location) {
        if (MoEUtils.isEmptyString(name)) {
            Logger.e(TAG + " User attribute value cannot be null");
            return this;
        }
        this.attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrLocation(name, location).build());
        return this;
    }

    public MoEHelper setUserAttribute(@NonNull String name, @NonNull GeoLocation location) {
        if (MoEUtils.isEmptyString(name)) {
            Logger.e(TAG + " User attribute value cannot be null");
            return this;
        }
        this.attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrLocation(name, location).build());
        return this;
    }

    public void setUserLocation(double lat, double lng) {
        this.setUserAttribute("last_known_location", new GeoLocation(lat, lng));
    }

    @WorkerThread
    public int getUnreadMessagesCount() {
        return this.dispatcher.getUnreadMessageCount();
    }

    @Nullable
    @WorkerThread
    public static Cursor getAllMessages(Context context) {
        return MoEDispatcher.getInstance(context).getAllMessages();
    }

    @WorkerThread
    public static void setMessageClicked(Context context, long id) {
        MoEDispatcher.getInstance(context).setInboxMessageClicked(id);
    }

    public void logoutUser() {
        if (null == this.context) {
            return;
        }
        this.dispatcher.logoutUser(false);
    }

    public void syncInteractionDataNow() {
        this.dispatcher.sendInteractionData();
    }

    public void trackNotificationClickedByTime(long gtime) {
        this.dispatcher.trackNotificationClicked(gtime);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void registerActivityLifecycle(Application application) {
        Logger.d("MoEHelper: Auto integration is enabled");
        if (application == null) {
            Logger.e(TAG + " registerActivityLifecycle() : Cannot resiter for lifecycle callbacks. Application instance is null.");
            return;
        }
        this.application = application;
        if (this.lifeCycleCallBacks == null) {
            this.lifeCycleCallBacks = new MoEActivityLifeCycleCallBacks();
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.lifeCycleCallBacks);
        }
    }

    public void unregisterLifecycleCallbacks(@NonNull Application application) {
        if (this.lifeCycleCallBacks != null && application != null) {
            Logger.v(TAG + " unregisterLifecycleCallbacks() : un-registering for lifecycle callbacks");
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.lifeCycleCallBacks);
        } else {
            Logger.v(TAG + " unregisterLifecycleCallbacks() : either lifecycle callbacks or application class instance is null cannot unregister.");
        }
    }

    public MoEDispatcher getDelegate() {
        if (null == this.dispatcher) {
            this.dispatcher = MoEDispatcher.getInstance(this.context);
        }
        return this.dispatcher;
    }

    public void setEmail(@NonNull String value) {
        this.setUserAttribute("USER_ATTRIBUTE_USER_EMAIL", value);
    }

    public void setFullName(@NonNull String value) {
        this.setUserAttribute("USER_ATTRIBUTE_USER_NAME", value);
    }

    @Deprecated
    public void setGender(@NonNull String value) {
        if (MoEUtils.isEmptyString(value)) {
            Logger.e(TAG + " setGender() : Cannot set null gender value.");
            return;
        }
        this.setUserAttribute("USER_ATTRIBUTE_USER_GENDER", value.toLowerCase());
    }

    public void setGender(@NonNull UserGender gender) {
        this.setUserAttribute("USER_ATTRIBUTE_USER_GENDER", gender.toString().toLowerCase());
    }

    public void setFirstName(@NonNull String value) {
        this.setUserAttribute("USER_ATTRIBUTE_USER_FIRST_NAME", value);
    }

    public void setLastName(@NonNull String value) {
        this.setUserAttribute("USER_ATTRIBUTE_USER_LAST_NAME", value);
    }

    public void setBirthDate(@NonNull Date birthDate) {
        this.attributeManager.setCustomUserAttribute(new PayloadBuilder().putAttrDate("USER_ATTRIBUTE_USER_BDAY", birthDate).build());
    }

    public void setUniqueId(@NonNull String value) {
        if (MoEUtils.isEmptyString(value)) {
            Logger.e(TAG + " setUniqueId() : Cannot set null unique id.");
            return;
        }
        this.setUserAttribute("USER_ATTRIBUTE_UNIQUE_ID", value);
    }

    public void setUniqueId(int value) {
        this.setUserAttribute("USER_ATTRIBUTE_UNIQUE_ID", value);
    }

    public void setUniqueId(long value) {
        this.setUserAttribute("USER_ATTRIBUTE_UNIQUE_ID", value);
    }

    public void setUniqueId(float value) {
        this.setUserAttribute("USER_ATTRIBUTE_UNIQUE_ID", value);
    }

    public void setUniqueId(double value) {
        this.setUserAttribute("USER_ATTRIBUTE_UNIQUE_ID", value);
    }

    public void setNumber(String value) {
        if (!TextUtils.isEmpty((CharSequence)value)) {
            this.setUserAttribute("USER_ATTRIBUTE_USER_MOBILE", value);
        }
    }

    public void trackDeviceLocale() {
        this.dispatcher.trackDeviceLocale();
    }

    public void setAlias(double currentId) {
        try {
            JSONObject userJSON = new JSONObject();
            userJSON.put("USER_ATTRIBUTE_UNIQUE_ID", currentId);
            this.dispatcher.setAlias(userJSON);
        }
        catch (Exception e) {
            Logger.e(TAG + " setAlias() ", e);
        }
    }

    public void setAlias(String currentId) {
        try {
            if (TextUtils.isEmpty((CharSequence)currentId)) {
                Logger.e(TAG + "Updated id cannot be null");
                return;
            }
            JSONObject userJSON = new JSONObject();
            userJSON.put("USER_ATTRIBUTE_UNIQUE_ID", (Object)currentId.trim());
            this.dispatcher.setAlias(userJSON);
        }
        catch (Exception e) {
            Logger.e(TAG + " setAlias() ", e);
        }
    }

    public void setAlias(long currentId) {
        try {
            JSONObject userJSON = new JSONObject();
            userJSON.put("USER_ATTRIBUTE_UNIQUE_ID", currentId);
            this.dispatcher.setAlias(userJSON);
        }
        catch (Exception e) {
            Logger.e(TAG + " setAlias() ", e);
        }
    }

    public void setAlias(int currentId) {
        try {
            JSONObject userJSON = new JSONObject();
            userJSON.put("USER_ATTRIBUTE_UNIQUE_ID", currentId);
            this.dispatcher.setAlias(userJSON);
        }
        catch (Exception e) {
            Logger.e(TAG + " setAlias() ", e);
        }
    }

    public void trackUserPushPreference(boolean pushPreference) {
        this.setUserAttribute("USER_PUSH_PREFERENCE", pushPreference);
    }

    public void fetchDeviceTriggersIfRequired() {
        MoEDTManager.getInstance().syncDeviceTriggersIfRequired(this.context);
    }

    @Deprecated
    public void setOnLogoutCompleteListener(OnLogoutCompleteListener listener) {
        MoECallbacks.getInstance().addLogoutCompleteListener(listener);
    }

    @Deprecated
    public void removeLogoutCompleteListener() {
    }

    public MoEHelper setUserAttributeISODate(@NonNull String attributeName, @NonNull String attributeValue) {
        if (MoEUtils.isEmptyString(attributeName) || MoEUtils.isEmptyString(attributeValue)) {
            return this;
        }
        if (!MoEUtils.isIsoDate(attributeValue)) {
            return this;
        }
        this.dispatcher.setCustomUserAttribute(new PayloadBuilder().putAttrISO8601Date(attributeName, attributeValue).build());
        return this;
    }

    @Deprecated
    public void registerAppBackgroundListener(@NonNull OnAppBackgroundListener listener) {
        Logger.v(TAG + " registerAppBackgroundListener() : Registering OnAppBackgroundListener");
        MoECallbacks.getInstance().addAppBackgroundListener(listener);
    }

    @Deprecated
    public void unregisterAppBackgroundListener() {
    }

    public MoEAttributeManager getAttributeManager() {
        return this.getDelegate().getAttributeManager();
    }

    public void trackEventFromSegment(String eventName, JSONObject eventAttributes) {
        this.getDelegate().addTaskToQueue(new TrackSegmentEventTask(this.context, eventName, eventAttributes));
    }

    public void trackUserAttributeFromSegment(Map<String, Object> userAttributesMap) {
        this.getDelegate().addTaskToQueue(new TrackSegmentUserAttributeTask(this.context, userAttributesMap));
    }

    public boolean isFirstScreen() {
        return this.isFirstScreen;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setFirstScreen(boolean firstScreen) {
        this.isFirstScreen = firstScreen;
    }

    public static boolean isAppInBackground() {
        return activityCounter <= 0;
    }

    @Nullable
    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setAppStatus(AppStatus status) {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        MoEDispatcher.getInstance(this.context).addTaskToQueue(new TrackInstallUpdateTask(this.context, status));
    }

    public void setAppContext(List<String> appContext) {
        this.appContext = appContext;
    }

    @Nullable
    public List<String> getAppContext() {
        return this.appContext;
    }

    public void resetAppContext() {
        this.appContext = null;
    }
}

