package com.moengage.core.userattributes;

import android.content.Context;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.RemoteConfig;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class MoEAttributeManager {

  private static final String TAG = "MoEAttributeManager";

  private Context context;

  public MoEAttributeManager(Context context){
    this.context = context;
  }

  public void setUserAttribute(JSONObject userJson){
    if (!shouldTrackUserAttribute()) return;
    MoEDispatcher.getInstance(context).addTaskToQueueBeginning(new TrackAttributeTask(context,
        userJson, false));
  }

  public void setCustomUserAttribute(JSONObject userJson){
    if (!shouldTrackUserAttribute()) return;
    MoEDispatcher.getInstance(context).addTaskToQueueBeginning(new TrackAttributeTask(context,
        userJson, true));
  }

  private boolean shouldTrackUserAttribute(){
    ConfigurationProvider provider = ConfigurationProvider.getInstance(context);
    if (!RemoteConfig.getConfig().isAppEnabled){
      Logger.e(TAG + " shouldTrackUserAttribute(): Account disabled will not track attribute");
      return false;
    }
    if (provider.isDataTrackingOptedOut()){
      Logger.e(TAG + " shouldTrackUserAttribute(): Data tracking opt-ed out cannot track "
          + "attribute");
      return false;
    }
    return true;
  }
}
