package com.moengage.core.model;

import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.MoEConstants;
import com.moengage.core.utils.JsonBuilder;

/**
 * @author Umang Chamaria
 * Date: 2019-05-06
 */
public class BaseRequest {
  public final String appId;
  public final JsonBuilder defaultParams;
  public final String uniqueId;
  public final String platform;
  public final int sdkVersion;

  public BaseRequest(String appId, JsonBuilder defaultParams, String uniqueId) {
    this.appId = appId;
    this.defaultParams = defaultParams;
    this.uniqueId = uniqueId;
    this.platform = MoEConstants.GENERIC_PARAM_V2_VALUE_OS;
    this.sdkVersion = MoEHelperConstants.LIB_VERSION;
  }

  public BaseRequest(BaseRequest request){
    this(request.appId, request.defaultParams, request.uniqueId);
  }

}

