package com.moengage.core;

import android.content.Context;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.Set;
import org.json.JSONObject;

/**
 * Loads configuration shared preference file into the cache.
 *
 * @author Umang Chamaria
 * Date: 2019-06-18
 */
public class LoadConfigurationFromDiskTask extends SDKTask {
  private static final String TAG = "LoadConfigurationFromDiskTask";

  LoadConfigurationFromDiskTask(Context context) {
    super(context);
  }

  @Override public TaskResult execute() {
    loadRemoteConfigFromDisk();
    return null;
  }

  private void loadRemoteConfigFromDisk() {
    try {
      String configurationString =
          ConfigurationProvider.getInstance(context).getRemoteConfiguration();
      RemoteConfig configuration = new RemoteConfig();

      if (configurationString != null){
        RemoteConfig storedConfig =
            RemoteConfig.fromJson(new JSONObject(configurationString));
        if (storedConfig != null){
          configuration = storedConfig;
        }
      }
      RemoteConfig.setRemoteConfig(configuration);

      Set<String> savedScreenNames =
          ConfigurationProvider.getInstance(context).getSentScreenNames();
      if (savedScreenNames != null){
        ConfigurationCache.getInstance().initialiseSentScreens(savedScreenNames);
      }
      if (ConfigurationProvider.getInstance(context).isDebugLogEnabled()) {
        SdkConfig.getConfig().isLogEnabledForSignedBuild = true;
        SdkConfig.getConfig().logLevel = Logger.VERBOSE;
      }

    } catch (Exception e) {
      Logger.e( TAG + " loadRemoteConfigFromDisk() : Exception ", e);
    }
  }

  @Override public String getTaskTag() {
    return TAG_LOAD_CONFIGURATION_FROM_DISK;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

}