/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moe.pushlibrary;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import com.moengage.core.Logger;

/**
 * Lifecycle Callbacks for auto-integration {@link Application#registerActivityLifecycleCallbacks(Application.ActivityLifecycleCallbacks)}<br>
 * @author  Umang Chamaria
 */
@TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
public class MoEActivityLifeCycleCallBacks implements Application.ActivityLifecycleCallbacks {

  private MoEHelper moEHelper;

  @Override
  public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    try {
      initializeMoEngageHelper(activity);
    } catch (Exception e) {
      Logger.e("MoEActivityLifeCycleCallBacks : onActivityCreated", e);
    }
  }

  @Override
  public void onActivityStarted(Activity activity) {
    try {
      initializeMoEngageHelper(activity);
      if (moEHelper != null) {
        moEHelper.onStartInternal(activity);
      }
    } catch (Exception e) {
      Logger.e("MoEActivityLifeCycleCallBacks : onActivityStarted", e);
    }
  }

  @Override
  public void onActivityResumed(Activity activity) {
    try {
      initializeMoEngageHelper(activity);
      if (moEHelper != null) {
        moEHelper.onResumeInternal(activity);
      }
    } catch (Exception e) {
      Logger.e("MoEActivityLifeCycleCallBacks : onActivityResumed", e);
    }
  }

  @Override
  public void onActivityPaused(Activity activity) {
    //Do Nothing
  }

  @Override
  public void onActivityStopped(Activity activity) {
    try {
      initializeMoEngageHelper(activity);
      if (moEHelper != null) {
        moEHelper.onStopInternal(activity);
      }
    } catch (Exception e) {
      Logger.e("MoEActivityLifeCycleCallBacks : onActivityStopped", e);
    }
  }

  @Override
  public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    try {
      initializeMoEngageHelper(activity);
      if (moEHelper != null) {
        moEHelper.onSaveInstanceState(outState);
      }
    } catch (Exception e) {
      Logger.e("MoEActivityLifeCycleCallBacks : onActivitySaveInstanceState", e);
    }
  }

  @Override
  public void onActivityDestroyed(Activity activity) {
    //Do Nothing
  }

  private void initializeMoEngageHelper(Activity activity){
    if (moEHelper == null && activity != null) {
      moEHelper = MoEHelper.getInstance(activity.getApplicationContext());
    }
  }
}
