/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.reports;

import android.content.Context;
import android.support.annotation.Nullable;
import com.moe.pushlibrary.models.BatchData;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.model.DevicePreferences;
import com.moengage.core.model.ReportBatch;
import com.moengage.core.model.ReportBatchMeta;
import com.moengage.core.model.SDKIdentifiers;
import com.moengage.core.model.TrafficSource;
import com.moengage.core.model.UserSession;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportsBatchHelper {
    private static final String TAG = "ReportsBatchHelper";
    private Object lock = new Object();
    private static final String REQUEST_ATTR_SOURCE = "source";
    private static final String REQUEST_ATTR_SESSION = "session";
    private static final String ATTR_MOE_USER_ID = "moe_user_id";
    private static final String ATTR_SEGMENT_ID = "segment_id";
    private static final String ATTR_DEVICE_ADD_RESPONSE = "dev_add_res";

    public BatchData updateBatchIfRequired(Context context, BatchData batch) {
        try {
            JSONObject batchJson = batch.batchDataJson;
            if (batchJson.has("MOE-REQUEST-ID")) {
                Logger.v("ReportsBatchHelper updateBatchIfRequired() : Batch already updated. No update required.");
                return batch;
            }
            Logger.v("ReportsBatchHelper updateBatchIfRequired() : Batch does not have request id and time will add it now.");
            batch.batchDataJson = this.updateBatch(batchJson, MoEDAO.getInstance(context).getSDKIdentifiers());
            if (batch._id != -1L) {
                MoEDAO.getInstance(context).updateBatch(batch);
            }
        }
        catch (Exception e) {
            Logger.e("ReportsBatchHelper updateBatchIfRequired() : Exception: ", e);
        }
        return batch;
    }

    JSONObject updateBatch(JSONObject batchJson, SDKIdentifiers identifiers) throws JSONException {
        ReportBatchMeta batchMeta = this.batchMetaFromJson(batchJson);
        JSONObject metaJson = new JSONObject();
        metaJson.put("bid", (Object)batchMeta.batchId);
        metaJson.put("request_time", (Object)batchMeta.requestTime);
        JSONObject preferencesJson = this.devicePreferencesJson(batchMeta.preferences);
        if (preferencesJson != null) {
            metaJson.put("dev_pref", (Object)preferencesJson);
        }
        batchJson.put("meta", (Object)metaJson);
        String requestId = MoEUtils.getSha1ForString(batchMeta.batchId + batchMeta.requestTime + identifiers.sdkUniqueId);
        batchJson.put("MOE-REQUEST-ID", (Object)requestId);
        return batchJson;
    }

    ReportBatchMeta batchMetaFromJson(JSONObject batchJson) {
        ReportBatchMeta batchMeta = this.savedBatchMeta(batchJson);
        if (batchMeta == null) {
            batchMeta = new ReportBatchMeta(null, MoEUtils.getRequestId(), MoEUtils.currentISOTime());
        } else {
            if (MoEUtils.isEmptyString(batchMeta.batchId)) {
                batchMeta.batchId = MoEUtils.getRequestId();
            }
            if (MoEUtils.isEmptyString(batchMeta.requestTime)) {
                batchMeta.requestTime = MoEUtils.currentISOTime();
            }
        }
        return batchMeta;
    }

    @Nullable
    ReportBatchMeta savedBatchMeta(JSONObject batchJson) {
        try {
            if (!batchJson.has("meta")) {
                return null;
            }
            JSONObject metaJson = batchJson.getJSONObject("meta");
            DevicePreferences preferences = null;
            if (metaJson.has("dev_pref")) {
                JSONObject devicePreferences = metaJson.getJSONObject("dev_pref");
                preferences = new DevicePreferences(devicePreferences.has("e_t_p"), devicePreferences.has("in_app_p"), devicePreferences.has("push_p"));
            }
            return new ReportBatchMeta(preferences, metaJson.optString("bid", null), metaJson.optString("request_time", null));
        }
        catch (Exception e) {
            Logger.e("ReportsBatchHelper batchMetaFromJson() : Exception: ", e);
            return null;
        }
    }

    @Nullable
    JSONObject devicePreferencesJson(DevicePreferences preferences) {
        JSONObject preferencesJson = new JSONObject();
        try {
            if (preferences == null) {
                return null;
            }
            if (preferences.isDataTrackingOptedOut) {
                preferencesJson.put("e_t_p", false);
            }
            if (preferences.isPushOptedOut) {
                preferencesJson.put("push_p", false);
            }
            if (preferences.isInAppOptedOut) {
                preferencesJson.put("in_app_p", false);
            }
        }
        catch (Exception e) {
            Logger.e("ReportsBatchHelper devicePreferencesJson() : Exception: ", e);
        }
        return preferencesJson.length() > 0 ? preferencesJson : null;
    }

    @Nullable
    JSONObject identifierJson(SDKIdentifiers identifiers) {
        JSONObject identifiersJson = new JSONObject();
        try {
            if (identifiers.userAttributeUniqueId != null) {
                identifiersJson.put(ATTR_MOE_USER_ID, (Object)identifiers.userAttributeUniqueId);
            }
            if (identifiers.segmentAnonymousId != null) {
                identifiersJson.put(ATTR_SEGMENT_ID, (Object)identifiers.segmentAnonymousId);
            }
        }
        catch (Exception e) {
            Logger.e("ReportsBatchHelper getIdentifiers() : Exception: ", e);
        }
        return identifiersJson.length() > 0 ? identifiersJson : null;
    }

    public void createAndSaveBatches(Context context, UserSession session) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<Event> eventList = null;
            MoEDAO dao = MoEDAO.getInstance(context);
            DevicePreferences devicePreferences = dao.getDevicePreferences();
            while (true) {
                eventList = dao.getInteractionData(100);
                Logger.d("ReportsBatchHelper: createAndSaveBatches() :Fetching interaction data in batches");
                if (eventList == null || eventList.isEmpty()) {
                    Logger.d("ReportsBatchHelpercreateAndSaveBatches(): Found Nothing to send");
                    return;
                }
                ReportBatch reportBatch = new ReportBatch(eventList, new ReportBatchMeta(devicePreferences, MoEUtils.getRequestId(), MoEUtils.currentISOTime(), session, !MoEDAO.getInstance(context).isDeviceRegistered()), dao.getSDKIdentifiers());
                String interactionData = this.createBatch(reportBatch);
                if (interactionData == null) {
                    return;
                }
                dao.writeBatch(interactionData);
                dao.deleteInteractionData(eventList, context);
                eventList.clear();
            }
        }
    }

    @Nullable
    String createBatch(ReportBatch reportBatch) {
        try {
            JSONObject sdkIdentifiers;
            JSONObject batch = new JSONObject();
            JSONArray viewsInfoArray = new JSONArray();
            for (Event event : reportBatch.getEventList()) {
                viewsInfoArray.put((Object)new JSONObject(event.details));
            }
            batch.put("viewsCount", viewsInfoArray.length()).put("viewsInfo", (Object)viewsInfoArray);
            JSONObject sdkMeta = this.metaJson(reportBatch.getBatchMeta());
            if (sdkMeta != null) {
                batch.put("meta", (Object)sdkMeta);
            }
            if ((sdkIdentifiers = this.identifierJson(reportBatch.getSdkIdentifiers())) != null) {
                batch.put("identifiers", (Object)sdkIdentifiers);
            }
            batch.put("MOE-REQUEST-ID", (Object)MoEUtils.getSha1ForString(reportBatch.getBatchMeta().batchId + reportBatch.getBatchMeta().requestTime + reportBatch.getSdkIdentifiers().sdkUniqueId));
            return batch.toString();
        }
        catch (Exception e) {
            Logger.e("ReportsBatchHelper createBatch() : Exception: ", e);
            return null;
        }
    }

    JSONObject metaJson(ReportBatchMeta meta) {
        JSONObject metaJson = new JSONObject();
        try {
            UserSession userSession;
            metaJson.put("bid", (Object)meta.batchId);
            metaJson.put("request_time", (Object)meta.requestTime);
            JSONObject devicePreferences = this.devicePreferencesJson(meta.preferences);
            if (devicePreferences != null) {
                metaJson.put("dev_pref", (Object)devicePreferences);
            }
            if (meta.isDeviceAddPending) {
                metaJson.put(ATTR_DEVICE_ADD_RESPONSE, (Object)"failure");
            }
            if ((userSession = meta.userSession) != null) {
                JSONObject trafficJson;
                JSONArray sourceArray = new JSONArray();
                if (userSession.getSource() != null && !TrafficSource.isEmpty(userSession.getSource()) && MoEUtils.hasKeys(trafficJson = TrafficSource.toJson(userSession.getSource()))) {
                    sourceArray.put((Object)trafficJson);
                }
                metaJson.put(REQUEST_ATTR_SOURCE, (Object)sourceArray);
                JSONObject sessionJson = UserSession.toJson(userSession);
                if (sessionJson != null) {
                    if (sessionJson.has("source_array")) {
                        sessionJson.remove("source_array");
                    }
                    if (sessionJson.has("last_interaction_time")) {
                        sessionJson.remove("last_interaction_time");
                    }
                    if (sessionJson.has("background_initiated") && sessionJson.getInt("background_initiated") != 1) {
                        sessionJson.remove("background_initiated");
                    }
                    metaJson.put(REQUEST_ATTR_SESSION, (Object)sessionJson);
                }
            }
            return metaJson;
        }
        catch (Exception e) {
            Logger.e("ReportsBatchHelper metaJson() : Exception: ", e);
            return metaJson;
        }
    }
}

