/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.events;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.RemoteConfig;
import com.moengage.core.analytics.AnalyticsHelper;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.inapp.InAppManager;

class TrackEventTask
extends SDKTask {
    private static final String TAG = "TrackEventTask";
    private Event event;

    TrackEventTask(Context context, Event event) {
        super(context);
        this.event = event;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("TrackEventTask : executing task");
            if (this.event.eventName == null) {
                Logger.e("TrackEventTask execute() : Event name is null cannot track it.");
                return null;
            }
            MoEEventManager eventManager = MoEEventManager.getInstance(this.context);
            ConfigurationProvider configProvider = ConfigurationProvider.getInstance(this.context);
            if (!eventManager.eventHandler.shouldTrackEvent(configProvider.isDataTrackingOptedOut(), RemoteConfig.getConfig().gdprWhitelistEventList, RemoteConfig.getConfig().blacklistedEvents, this.event.eventName)) {
                Logger.e("TrackEventTask execute() :  Either data tracking is opted out and this is not a GDPR whitelist event cannot track or event is blacklisted Event Name: " + this.event.eventName);
                return this.taskResult;
            }
            InAppManager.getInstance().showTriggerInAppIfPossible(this.context, this.event);
            AnalyticsHelper.getInstance(this.context).onEventTracked(this.event, this.context);
            MoEDTManager.getInstance().showTriggerIfPossible(this.context, this.event.eventName, this.event.attributes);
            eventManager.writeDataPointToStorage(this.event);
            eventManager.flushIfRequired(this.event);
            MoEEventManager.getInstance(this.context).incrementEventCounter();
            Logger.v("TrackEventTask execute() : Cached event count: " + MoEEventManager.getInstance(this.context).getEventCounter());
            if (eventManager.getEventCounter() == RemoteConfig.getConfig().eventBatchCount) {
                Logger.d("Unique Id set, So will try to send data");
                MoEDispatcher.getInstance(this.context).sendInteractionData();
            }
            Logger.v("TrackEventTask : completed execution");
        }
        catch (Exception e) {
            Logger.e("TrackEventTask execute() : Exception: ", e);
        }
        return null;
    }

    @Override
    public String getTaskTag() {
        return "TRACK_EVENT";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

