/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.storage;

import android.content.Context;
import android.net.Uri;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moe.pushlibrary.providers.MoEDataContract.BaseColumns;

/**
 * @author Umang Chamaria
 * Date: 17/05/20
 */
public class CardsDataContract {

  interface CardsColumns extends BaseColumns {
    String CARD_ID = "card_id";
    String CATEGORY = "category";
    String CAMPAIGN_STATE = "campaign_state";
    String VISIBILITY_STATUS = "visibility_status";
    String LAST_UPDATED_TIME = "last_updated_time";
    String CAMPAIGN_PAYLOAD = "campaign_payload";
    String IS_PINNED = "is_pinned";
    String DELETION_TIME = "deletion_time";
    String IS_NEW_CARD = "is_new_card";
    String IS_DELETED = "is_deleted";
    String PRIORITY = "priority";

    int COLUMN_INDEX_CARD_ID = 1;
    int COLUMN_INDEX_CATEGORY = 2;
    int COLUMN_INDEX_CAMPAIGN_STATE = 3;
    int COLUMN_INDEX_VISIBILITY_STATUS = 4;
    int COLUMN_INDEX_LAST_UPDATED_TIME = 5;
    int COLUMN_INDEX_CAMPAIGN_PAYLOAD = 6;
    int COLUMN_INDEX_IS_PINNED = 7;
    int COLUMN_INDEX_DELETION_TIME = 8;
    int COLUMN_INDEX_IS_NEW_CARD = 9;
    int COLUMN_INDEX_IS_DELETED = 10;
    int COLUMN_INDEX_PRIORITY = 11;
  }

  public static final class CardsEntity implements CardsColumns {
    public static Uri getContentUri(Context context) {
      return Uri.parse("content://" + MoEDataContract.getAuthority(context) + "/cards");
    }

    public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.moe.cards";
    public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.moe.cards";

    public static final String[] PROJECTION = {
        _ID,
        CARD_ID,
        CATEGORY,
        CAMPAIGN_STATE,
        VISIBILITY_STATUS,
        LAST_UPDATED_TIME,
        CAMPAIGN_PAYLOAD,
        IS_PINNED,
        DELETION_TIME,
        IS_NEW_CARD,
        IS_DELETED,
        PRIORITY
    };
    public static final String DEFAULT_SORT_ORDER = LAST_UPDATED_TIME + " DESC";

    public static final String DELETED_FILTER = IS_DELETED + " = 0 ";

    public static final String VISIBILITY_STATUS_FILTER = VISIBILITY_STATUS + " = \"SHOW\" ";

    public static final String FILTER_HIDDEN_CARDS_AND_DELETED_CARDS =
        VISIBILITY_STATUS_FILTER + " AND " + DELETED_FILTER;
  }
}
