/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.remoteconfig;

import android.content.Context;
import android.text.TextUtils;
import com.moengage.core.APIManager;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;
import com.moengage.core.RestUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.rest.Response;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class ConfigApiNetworkTask extends SDKTask {
  private static final String TAG = "ConfigApiNetworkTask";

  public ConfigApiNetworkTask(Context context) {
    super(context);
  }

  @Override public TaskResult execute() {
    Logger.v("ConfigApiNetworkTask : executing Task");
    try {
      String appId = MoEUtils.getAppId();
      if (TextUtils.isEmpty(appId)) {
        Logger.e(TAG + " execute(): Cannot make config api sync request without app id.");
        return taskResult;
      }

      JSONObject requestBody = new JSONObject();
      requestBody.put(MoEConstants.REQUEST_ATTR_QUERY_PARAMS,
          RestUtils.getDefaultParams(context).build());
      Response response = APIManager.configApi(appId, requestBody);

      RemoteConfigResponseHandler handler = new RemoteConfigResponseHandler();
      boolean status = handler.handleConfigApiResponse(context, response);

      taskResult.setIsSuccess(status);
    } catch (Exception e) {
      Logger.e("ConfigApiNetworkTask : execute", e);
    }
    Logger.v("ConfigApiNetworkTask : execution completed");
    return taskResult;
  }

  @Override public String getTaskTag() {
    return TAG_SYNC_CONFIG_API;
  }

  @Override public boolean isSynchronous() {
    return true;
  }

}
