/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.integrations.segment;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Transform Segment's User Attribute to MoEngage format.
 *
 * @author Umang Chamaria
 * Date: 29/04/19
 */
public class TrackSegmentUserAttributeTask extends SDKTask {

  private Map<String, Object> userAttributesMap;

  private static final String TAG = "TrackSegmentUserAttributeTask";

  public TrackSegmentUserAttributeTask(Context context, Map<String, Object> userAttributesMap) {
    super(context);
    this.userAttributesMap = userAttributesMap;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " execute() : Transforming identifiers to "
          + "MoEngage format.");
      trackSegmentId();
      List<String> removeAttributeList = new ArrayList<>();
      for (Map.Entry<String, Object> entry : userAttributesMap.entrySet()) {
        String attributeName = entry.getKey();
        Object attributeValue = entry.getValue();
        if (attributeValue instanceof String && MoEUtils.isDate((String) attributeValue)) {
          MoEHelper.getInstance(context).setUserAttributeISODate(attributeName,
              attributeValue.toString());
          removeAttributeList.add(attributeName);
        }
      }
      for (String attribute : removeAttributeList) {
        userAttributesMap.remove(attribute);
      }
      MoEHelper.getInstance(context).setUserAttribute(userAttributesMap);
    } catch (Exception e) {
      Logger.e(TAG + " execute() : Exception ", e);
    }
    return null;
  }

  private void trackSegmentId() {
    try {
      if (userAttributesMap.containsKey(MoEHelperConstants.USER_ATTRIBUTE_SEGMENT_ID)){
        String segmentId =
            (String) userAttributesMap.get(MoEHelperConstants.USER_ATTRIBUTE_SEGMENT_ID);
        if (!MoEUtils.isEmptyString(segmentId)){
          ConfigurationProvider.getInstance(context).saveSegmentAnonymousId(segmentId);
        }
      }
    } catch (Exception e) {
      Logger.e( TAG + " trackSegmentId() : ", e);
    }
  }

  @Override public String getTaskTag() {
    return TAG_TRACK_USER_ATTRIBUTE_SEGMENT;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
