/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.moe.pushlibrary.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.moengage.core.Logger;
import org.json.JSONObject;

/**
 * Data object for Inbox messages
 *
 * @author MoEngage (abhishek@moenegage.com)
 * @version 5.0
 * @since 5.0
 */
public class PromotionalMessage implements Parcelable {
	/**
	 * Database Id
	 */
	public long _id;
	/**
	 * Notification payload
	 */
	public JSONObject msg_details;
	/**
	 * is notification clicked
	 */
	public boolean isClicked;
	/**
	 * Notification payload
	 */
	public long ttl;

	public long gtime;

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.os.Parcelable#describeContents()
	 */
	@Override
	public int describeContents() {
		return 0;
	}

	public static final Parcelable.Creator<PromotionalMessage> CREATOR = new Parcelable.Creator<PromotionalMessage>() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see
		 * android.os.Parcelable.Creator#createFromParcel(android.os.Parcel)
		 */
		@Override
		public PromotionalMessage createFromParcel(Parcel source) {
			return new PromotionalMessage(source);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see android.os.Parcelable.Creator#newArray(int)
		 */
		@Override
		public PromotionalMessage[] newArray(int size) {
			return new PromotionalMessage[size];
		}

	};

	/*
	 * (non-Javadoc)
	 * 
	 * @see android.os.Parcelable#writeToParcel(android.os.Parcel, int)
	 */
	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeLong(_id);
		if (null != msg_details) {
			dest.writeString(msg_details.toString());
		} else {
			dest.writeString("");
		}
		dest.writeInt((isClicked ? 1 : 0));
		dest.writeLong(ttl);
		dest.writeLong(gtime);
	}
	public PromotionalMessage() {	}

	public PromotionalMessage(Parcel source) {
		readFromParcel(source);
	}

	public void readFromParcel(Parcel in) {
		_id = in.readLong();
		String details = in.readString();
		if (!TextUtils.isEmpty(details)) {
			try {
				msg_details = new JSONObject(details);
			} catch (Exception e) {
        Logger.e("PromotionalMessage : readFromParcel", e);
      }
		}
		int clicked = in.readInt();
		isClicked = clicked == 0 ? false : true;
		ttl = in.readLong();
		gtime = in.readLong();
	}

}
