/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.moe.pushlibrary.models.BatchData;
import com.moengage.core.APIManager;
import com.moengage.core.AdvertisingIdClient;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.DataSyncJob;
import com.moengage.core.Logger;
import com.moengage.core.MoEAlarmReceiver;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.OnJobComplete;
import com.moengage.core.SdkConfig;
import com.moengage.core.analytics.AnalyticsHelper;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.DevicePreferences;
import com.moengage.core.model.PushTokens;
import com.moengage.core.model.RemoteConfig;
import com.moengage.core.reports.ReportsBatchHelper;
import com.moengage.core.rest.Response;
import com.moengage.core.utils.JsonBuilder;
import com.moengage.core.utils.RestUtils;
import java.util.ArrayList;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

class SendInteractionDataTask
extends SDKTask {
    @Nullable
    private OnJobComplete jobCompleteCallback;
    @Nullable
    private JobParameters jobParameters;
    private ConfigurationProvider provider;
    private final String TAG = "SendInteractionDataTask";

    SendInteractionDataTask(Context context) {
        this(context, null, null);
    }

    SendInteractionDataTask(Context context, @Nullable OnJobComplete jobCompleteCallback, @Nullable JobParameters parameters) {
        super(context);
        this.jobCompleteCallback = jobCompleteCallback;
        this.jobParameters = parameters;
        this.provider = ConfigurationProvider.getInstance(this.context);
    }

    @Override
    public TaskResult execute() {
        try {
            if (!RemoteConfig.getConfig().isAppEnabled) {
                return null;
            }
            Logger.v("SendInteractionDataTask executing task");
            MoEDispatcher.getInstance(this.context).getBatchHelper().createAndSaveBatches(this.context, AnalyticsHelper.getInstance(this.context).getSession());
            MoEEventManager.getInstance(this.context).setEventCounter(0);
            String appId = MoEUtils.getAppId();
            if (TextUtils.isEmpty((CharSequence)appId)) {
                Logger.e("SendInteractionDataTask execute: App-id not present cannot make report add call.");
                return null;
            }
            this.sendInteractionData(appId);
            this.schedulePeriodicRetryIfRequired();
            this.releaseJobLockIfRequired();
            Logger.v("SendInteractionDataTask : completed task");
            return null;
        }
        catch (Exception e) {
            Logger.f("SendInteractionDataTask : execute() ", e);
            return null;
        }
    }

    private void releaseJobLockIfRequired() {
        if (Build.VERSION.SDK_INT >= 21 && this.jobCompleteCallback != null && this.jobParameters != null) {
            Logger.v("SendInteractionDataTask releaseJobLockIfRequired() : Trying to release job lock.");
            this.jobCompleteCallback.jobCompleted(this.jobParameters, false);
        }
    }

    @Override
    public String getTaskTag() {
        return "SEND_INTERACTION_DATA";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    private void sendInteractionData(String appId) {
        boolean result = false;
        ArrayList<BatchData> batchedData = null;
        String endpoint = "v2/sdk/report/" + appId;
        if (this.shouldSendDataToTestServer()) {
            endpoint = "integration/send_report_add_call";
        }
        ReportsBatchHelper batchHelper = new ReportsBatchHelper();
        while (true) {
            batchedData = MoEDAO.getInstance(this.context).getBatchedData(100);
            Logger.d("SendInteractionDataTask : sendInteractionData:Fetching interaction data in batches");
            if (batchedData == null || batchedData.isEmpty()) {
                Logger.d("SendInteractionDataTask : sendInteractionData: Found Nothing to send");
                return;
            }
            for (BatchData data : batchedData) {
                BatchData batch = batchHelper.updateBatchIfRequired(this.context, data);
                try {
                    String requestId = this.getRequestID(data.batchDataJson);
                    JSONObject requestBody = this.cleanBody(data.batchDataJson).put("query_params", (Object)this.getQueryParams());
                    Response response = APIManager.reportAdd(appId, endpoint, requestId, requestBody);
                    if (response != null && response.responseCode == 200) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    Logger.f("SendInteractionDataTask : API failed", e);
                    result = false;
                }
                if (result) {
                    Logger.d("SendInteractionDataTask : Batch sent successfully deleting batch");
                    MoEDAO.getInstance(this.context).deleteBatch(batch);
                    continue;
                }
                this.scheduleRetryIfRequired();
                break;
            }
            if (!result) break;
            batchedData.clear();
        }
    }

    private void scheduleRetryIfRequired() {
        int retryCount = this.provider.getImmediateRetryCount();
        switch (retryCount) {
            case 0: {
                this.scheduleImmediateRetry(1);
                this.provider.setImmediateRetryCount(++retryCount);
                break;
            }
            case 1: {
                this.scheduleImmediateRetry(3);
                this.provider.setImmediateRetryCount(++retryCount);
                break;
            }
            default: {
                this.provider.setImmediateRetryCount(0);
            }
        }
    }

    private boolean shouldSendDataToTestServer() {
        boolean isDeviceRegisteredForVerification = this.provider.isDeviceRegisteredForVerification();
        long registrationTime = this.provider.getVerificationRegistrationTime();
        return isDeviceRegisteredForVerification && registrationTime + 3600000L > MoEUtils.currentTime();
    }

    private void scheduleImmediateRetry(int minutes) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.scheduleSyncJob(666666, minutes * 60 * 1000);
        } else {
            this.scheduleSyncAlarm(55555, minutes * 60 * 1000);
        }
    }

    @Nullable
    private String getRequestID(JSONObject batchData) {
        try {
            return batchData.getString("MOE-REQUEST-ID");
        }
        catch (JSONException e) {
            Logger.e("SendInteractionDataTask: getRequestID(): Exception ", e);
            return null;
        }
    }

    private JSONObject cleanBody(JSONObject batchData) {
        batchData.remove("MOE-REQUEST-ID");
        return batchData;
    }

    private void schedulePeriodicRetryIfRequired() {
        if (!SdkConfig.getConfig().isBackgroundSyncEnabled) {
            return;
        }
        long syncInterval = RemoteConfig.getConfig().dataSyncRetryInterval;
        Logger.v("SendInteractionDataTask schedulePeriodicRetryIfRequired() : Will schedule background retry.");
        if (Build.VERSION.SDK_INT >= 21) {
            this.scheduleSyncJob(77777, syncInterval);
        } else {
            this.scheduleSyncAlarm(88888, syncInterval);
        }
    }

    private void scheduleSyncAlarm(int requestCode, long timeDelayMillis) {
        Intent alarmIntent = new Intent(this.context, MoEAlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)requestCode, (Intent)alarmIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)this.context.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.set(0, MoEUtils.currentTime() + timeDelayMillis, pendingIntent);
        }
    }

    @TargetApi(value=21)
    private void scheduleSyncJob(int requestCode, long timeDelayMillis) {
        ComponentName serviceComponent = new ComponentName(this.context, DataSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(requestCode, serviceComponent);
        builder.setRequiredNetworkType(1).setOverrideDeadline(MoEUtils.currentTime() + 2L * timeDelayMillis).setMinimumLatency(timeDelayMillis);
        JobScheduler jobScheduler = (JobScheduler)this.context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.schedule(builder.build());
        }
    }

    private JSONObject getQueryParams() throws JSONException {
        JsonBuilder builder = RestUtils.getDefaultParams(this.context);
        builder.putString("device_tz", TimeZone.getDefault().getID());
        DevicePreferences devicePreferences = MoEDAO.getInstance(this.context).getDevicePreferences();
        if (!devicePreferences.isPushOptedOut) {
            PushTokens pushTokens = MoEDAO.getInstance(this.context).getPushTokens();
            if (!MoEUtils.isEmptyString(pushTokens.fcmToken)) {
                builder.putString("push_id", pushTokens.fcmToken);
            }
            if (!MoEUtils.isEmptyString(pushTokens.oemToken)) {
                builder.putString("mi_push_id", pushTokens.oemToken);
            }
        }
        if (!devicePreferences.isDataTrackingOptedOut) {
            String androidId = MoEUtils.getAndroidID(this.context);
            if (!TextUtils.isEmpty((CharSequence)androidId)) {
                builder.putString("android_id", androidId);
            }
            if (!SdkConfig.getConfig().isGaidTrackingOptedOut) {
                AdvertisingIdClient.AdInfo adInfo;
                String gaid = this.provider.getStoredGAID();
                if (TextUtils.isEmpty((CharSequence)gaid) && (adInfo = MoEUtils.getAdvertisementInfo(this.context)) != null) {
                    gaid = adInfo.getId();
                    this.provider.storeGAID(gaid);
                }
                if (!TextUtils.isEmpty((CharSequence)gaid)) {
                    builder.putString("moe_gaid", gaid);
                }
            }
            builder.putString("os_ver", String.valueOf(Build.VERSION.SDK_INT));
            builder.putString("model", Build.MODEL);
            builder.putString("app_version_name", this.provider.getAppVersionName());
            String nwType = MoEUtils.getNetworkType(this.context);
            if (!TextUtils.isEmpty((CharSequence)nwType)) {
                builder.putString("networkType", nwType);
            }
        }
        return builder.build();
    }
}

