/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.Activity;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ActivityStartTask;
import com.moengage.core.ActivityStopTask;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.DeviceAddManager;
import com.moengage.core.Logger;
import com.moengage.core.LogoutTask;
import com.moengage.core.MoECallbacks;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoECoreEvaluator;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEWorkerTask;
import com.moengage.core.MoEngage;
import com.moengage.core.NotificationClickedTask;
import com.moengage.core.OnJobComplete;
import com.moengage.core.Properties;
import com.moengage.core.SdkConfig;
import com.moengage.core.SendInteractionDataTask;
import com.moengage.core.SetAliasTask;
import com.moengage.core.SetDeviceAttributeTask;
import com.moengage.core.analytics.AnalyticsHelper;
import com.moengage.core.cards.CardManager;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.OnTaskCompleteListener;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.executor.TaskProcessor;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.inapp.InAppManager;
import com.moengage.core.listeners.AppBackgroundListener;
import com.moengage.core.listeners.OnAppBackgroundListener;
import com.moengage.core.listeners.OnLogoutCompleteListener;
import com.moengage.core.mipush.MiPushManager;
import com.moengage.core.model.RemoteConfig;
import com.moengage.core.pushamp.PushAmpManager;
import com.moengage.core.remoteconfig.ConfigApiNetworkTask;
import com.moengage.core.reports.ReportsBatchHelper;
import com.moengage.core.userattributes.MoEAttributeManager;
import com.moengage.location.GeoManager;
import com.moengage.push.PushManager;
import com.moengage.push.hms.puskit.PushKitManager;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class MoEDispatcher
implements OnTaskCompleteListener {
    private static final String TAG = "MoEDispatcher";
    private Context context;
    private static MoEDispatcher instance;
    boolean shouldClearData = false;
    private boolean shouldTrackUniqueId = false;
    private JSONObject uniqueIdAttribute = null;
    private ScheduledExecutorService scheduler;
    private MoEAttributeManager attributeManager = null;
    private DeviceAddManager deviceAddManager = null;
    private MoECoreEvaluator coreEvaluator = null;
    private ReportsBatchHelper batchHelper = null;

    private MoEDispatcher(Context context) {
        if (context != null) {
            this.context = context;
            TaskProcessor.getInstance().setOnTaskCompleteListener(this);
            this.attributeManager = new MoEAttributeManager(context);
        } else {
            Logger.e("MoEDispatcher  : context is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoEDispatcher getInstance(Context context) {
        if (instance != null) return instance;
        Class<MoEDispatcher> clazz = MoEDispatcher.class;
        synchronized (MoEDispatcher.class) {
            if (instance != null) return instance;
            instance = new MoEDispatcher(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void checkForInAppMessages(boolean force) {
        Logger.v("MoEDispatcher: showInAppIfPossible: Check in app messages");
        if (force) {
            // empty if block
        }
    }

    public void onStart(Activity activity, Intent intent) {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        if (null == activity) {
            Logger.e("MoEDispatcher:onStart activity instance is null");
            return;
        }
        if (null == intent) {
            intent = activity.getIntent();
        }
        this.context = activity.getApplicationContext();
        Logger.v("MoEDispatcher:onStart ----");
        MoEHelperUtils.dumpIntentExtras(intent);
        this.addTaskToQueue(new ActivityStartTask(activity));
        InAppManager.getInstance().showInAppIfRequired(this.context);
        MoEUtils.updateTestDeviceState(this.context);
    }

    public void trackNotificationClicked(long gtime) {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        this.addTaskToQueue(new NotificationClickedTask(this.context, gtime));
    }

    public void setUserAttribute(JSONObject userJson) {
        this.attributeManager.setUserAttribute(userJson);
    }

    public void setCustomUserAttribute(JSONObject userJson) {
        this.attributeManager.setCustomUserAttribute(userJson);
    }

    public void onResume(Activity activity, boolean isRestoring) {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        if (!isRestoring) {
            this.showDialogAfterPushClick(activity);
        }
    }

    public void onStop(Activity activity) {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        if (null == activity) {
            return;
        }
        this.addTaskToQueue(new ActivityStopTask(this.context, activity.getClass().getName()));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void handleLogout(boolean isForcedLogout) {
        Logger.i("Started logout process");
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        CardManager.getInstance().onLogout(this.context);
        this.trackLogoutEvent(isForcedLogout);
        TaskManager.getInstance().addTaskToQueueBeginning(new SendInteractionDataTask(this.context));
        this.shouldClearData = true;
    }

    @WorkerThread
    private void trackLogoutEvent(boolean isForcedLogout) {
        try {
            Properties eventAttributes = new Properties();
            if (isForcedLogout) {
                eventAttributes.addAttribute("type", "forced");
            }
            eventAttributes.setNonInteractive();
            Event event = new Event("MOE_LOGOUT", eventAttributes.getPayload().build());
            MoEDAO.getInstance(this.context).addEvent(event);
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: trackLogoutEvent(): ", e);
        }
    }

    @WorkerThread
    void clearDataOnLogout() {
        this.shouldClearData = false;
        Logger.i("Completed logout process");
    }

    public void sendInteractionData() {
        this.startTask(new SendInteractionDataTask(this.context));
    }

    public void sendInteractionData(OnJobComplete jobComplete, JobParameters parameters) {
        this.startTask(new SendInteractionDataTask(this.context, jobComplete, parameters));
    }

    @WorkerThread
    public void setInboxMessageClicked(long id) {
        MoEDAO.getInstance(this.context).setMessageClicked(id);
    }

    @WorkerThread
    void handleAppUpdateEvent() {
        try {
            if (!RemoteConfig.getConfig().isAppEnabled) {
                return;
            }
            int prevVersion = ConfigurationProvider.getInstance(this.context).getStoredAppVersion();
            Properties eventObj = new Properties();
            eventObj.addAttribute("VERSION_FROM", prevVersion);
            eventObj.addAttribute("VERSION_TO", ConfigurationProvider.getInstance(this.context).getAppVersion());
            Logger.i("Adding an update event");
            MoEHelper.getInstance(this.context).trackEvent("UPDATE", eventObj);
            if (!MoEHelper.isAppInForeground()) {
                this.sendInteractionData();
            }
        }
        catch (Exception e) {
            Logger.f("Adding update event", e);
        }
    }

    @Nullable
    @WorkerThread
    public Cursor getAllMessages() {
        return MoEDAO.getInstance(this.context).getMessages(this.context);
    }

    @WorkerThread
    public int getUnreadMessageCount() {
        return MoEDAO.getInstance(this.context).getUnreadMessageCount();
    }

    public void initialize(String senderId, String appId) {
        MoEngage.setBuildStatus(MoEUtils.isDebugBuild(this.context));
        if (!TextUtils.isEmpty((CharSequence)appId)) {
            SdkConfig.getConfig().appId = MoEUtils.formatAppId(appId);
            if (!MoEUtils.isEmptyString(senderId)) {
                SdkConfig.getConfig().senderId = senderId;
            }
            if (SdkConfig.getConfig().isFcmPushRegistrationEnabled) {
                PushManager.getInstance().registerForPush(this.context);
            }
        } else {
            Logger.e("MoEDispatcher: initialize : AppId is null");
        }
    }

    private void showDialogAfterPushClick(Activity activity) {
        if (null == activity) {
            return;
        }
        try {
            Bundle extras;
            Intent intent = activity.getIntent();
            if (intent != null && (extras = intent.getExtras()) != null && extras.containsKey("gcm_show_dialog")) {
                intent.removeExtra("gcm_show_dialog");
                if (extras.containsKey("gcm_coupon_code")) {
                    MoEUtils.showCouponDialog(extras.getString("gcm_alert"), extras.getString("gcm_coupon_code"), (Context)activity);
                    intent.removeExtra("gcm_alert");
                    intent.removeExtra("gcm_coupon_code");
                } else {
                    MoEUtils.showNormalDialogWithOk(extras.getString("gcm_alert"), (Context)activity);
                    intent.removeExtra("gcm_alert");
                }
            }
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: showDialogAfterPushClick : ", e);
        }
    }

    @Deprecated
    public void addTaskToQueue(ITask task) {
        TaskManager.getInstance().addTaskToQueue(task);
    }

    @Deprecated
    public void addTaskToQueueBeginning(ITask task) {
        TaskManager.getInstance().addTaskToQueueBeginning(task);
    }

    @Deprecated
    public void startTask(ITask task) {
        TaskManager.getInstance().startTask(task);
    }

    @Override
    public void onTaskComplete(String tag, TaskResult taskResult) {
        Logger.v("Task completed : " + tag);
        switch (tag) {
            case "SEND_INTERACTION_DATA": {
                if (!this.shouldClearData) break;
                this.addTaskToQueueBeginning(new LogoutTask(this.context));
                break;
            }
            case "TRACK_ATTRIBUTE": {
                if (taskResult.isSuccess()) break;
                this.shouldTrackUniqueId = true;
                this.uniqueIdAttribute = (JSONObject)taskResult.getPayload();
                break;
            }
            case "DEVICE_ADD": {
                this.deviceAddManager.processTaskResult(this.context, taskResult);
                break;
            }
            case "SYNC_CONFIG": {
                this.onConfigApiSyncComplete(taskResult);
                break;
            }
            case "LOGOUT_TASK": {
                if (!this.shouldTrackUniqueId) break;
                this.trackChangedUniqueId();
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void syncConfigIfRequired() {
        if (ConfigurationProvider.getInstance(this.context).getLastConfigSyncTime() + MoEConstants.CONFIG_API_SYNC_DELAY < MoEUtils.currentTime()) {
            this.startTask(new ConfigApiNetworkTask(this.context));
        }
    }

    public void trackDeviceLocale() {
        try {
            if (!RemoteConfig.getConfig().isAppEnabled) {
                return;
            }
            this.trackDeviceAndUserAttribute("LOCALE_COUNTRY", Locale.getDefault().getCountry());
            this.trackDeviceAndUserAttribute("LOCALE_COUNTRY_DISPLAY", Locale.getDefault().getDisplayCountry());
            this.trackDeviceAndUserAttribute("LOCALE_LANGUAGE", Locale.getDefault().getLanguage());
            this.trackDeviceAndUserAttribute("LOCALE_LANGUAGE_DISPLAY", Locale.getDefault().getDisplayLanguage());
            this.trackDeviceAndUserAttribute("LOCALE_DISPLAY", Locale.getDefault().getDisplayName());
            this.trackDeviceAndUserAttribute("LOCALE_COUNTRY_ ISO3", Locale.getDefault().getISO3Country());
            this.trackDeviceAndUserAttribute("LOCALE_LANGUAGE_ISO3", Locale.getDefault().getISO3Language());
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher : trackDeviceLocale", e);
        }
    }

    private void trackDeviceAndUserAttribute(String attrName, String attrValue) {
        try {
            JSONObject attribute = new JSONObject();
            attribute.put(attrName, (Object)attrValue);
            this.setUserAttribute(attribute);
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: trackDeviceAndUserAttribute() ", e);
        }
    }

    public void logoutUser(boolean isForcedLogout) {
        try {
            Bundle extras = new Bundle();
            extras.putBoolean("IS_FORCE_LOGOUT", isForcedLogout);
            this.addTaskToQueue(new MoEWorkerTask(this.context, "LOGOUT", extras));
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: logoutUser() ", e);
        }
    }

    private void trackChangedUniqueId() {
        if (this.uniqueIdAttribute != null) {
            this.setUserAttribute(this.uniqueIdAttribute);
            this.uniqueIdAttribute = null;
            this.shouldTrackUniqueId = false;
        }
    }

    public void setAlias(JSONObject aliasJSON) {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        this.addTaskToQueue(new SetAliasTask(this.context, aliasJSON));
    }

    public void setDeviceAttribute(JSONObject deviceAttribute) {
        this.addTaskToQueue(new SetDeviceAttributeTask(this.context, deviceAttribute));
    }

    private void schedulePeriodicFlushIfRequired() {
        try {
            Logger.v("MoEDispatcher schedulePeriodicFlushIfRequired() : Will try to schedule periodic flush if enabled.");
            if (RemoteConfig.getConfig().isPeriodicFlushEnabled && SdkConfig.getConfig().isPeriodicFlushEnabled) {
                Runnable syncRunnable = new Runnable(){

                    @Override
                    public void run() {
                        Logger.v("MoEDispatcher: schedulePeriodicFlushIfRequired() inside runnable, will sync now");
                        MoEDispatcher.this.sendInteractionData();
                    }
                };
                long timeDelay = RemoteConfig.getConfig().periodicFlushTime;
                if (SdkConfig.getConfig().flushInterval > timeDelay) {
                    timeDelay = SdkConfig.getConfig().flushInterval;
                }
                Logger.v("MoEDispatcher: schedulePeriodicFlushIfRequired() scheduling periodic sync");
                this.scheduler = Executors.newScheduledThreadPool(1);
                this.scheduler.scheduleWithFixedDelay(syncRunnable, timeDelay, timeDelay, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            Logger.e("MoEDispatcher: schedulePeriodicFlushIfRequired() ", e);
        }
    }

    private void shutDownPeriodicFlush() {
        try {
            if (RemoteConfig.getConfig().isPeriodicFlushEnabled && SdkConfig.getConfig().isPeriodicFlushEnabled && this.scheduler != null) {
                Logger.v("MoEDispatcher: shutDownPeriodicFlush() shutting down periodic flush");
                this.scheduler.shutdownNow();
            }
        }
        catch (Exception e) {
            Logger.f("MoEDispatcher: shutDownPeriodicFlush() ", e);
        }
    }

    public void onAppOpen() {
        try {
            this.syncConfigIfRequired();
            this.updateFeatureConfigForOptOutIfRequired();
            GeoManager.getInstance().updateFenceAndLocation(this.context);
            InAppManager.getInstance().syncInAppsIfRequired(this.context);
            PushAmpManager.getInstance().forceServerSync(this.context, true);
            PushManager.getInstance().registerForPush(this.context);
            this.schedulePeriodicFlushIfRequired();
            MoEDTManager.getInstance().forceSyncDeviceTriggers(this.context);
            MiPushManager.getInstance().initMiPush(MoEHelper.getInstance(this.context).getApplication());
            PushKitManager.getInstance().onAppOpen(this.context);
            CardManager.getInstance().onAppOpen(this.context);
            if (ConfigurationProvider.getInstance(this.context).isDebugLogEnabled()) {
                SdkConfig.getConfig().isLogEnabledForSignedBuild = true;
                SdkConfig.getConfig().logLevel = 5;
            }
            PushManager.getInstance().onAppOpen(this.context);
        }
        catch (Exception e) {
            Logger.e("MoEDispatcher: onAppOpen() ", e);
        }
    }

    void updateFeatureConfigForOptOutIfRequired() {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.context);
        if (provider.isDataTrackingOptedOut()) {
            SdkConfig.getConfig().isGaidTrackingOptedOut = true;
            SdkConfig.getConfig().isAndroidIdTrackingOptedOut = true;
            SdkConfig.getConfig().isLocationTrackingOptedOut = true;
            SdkConfig.getConfig().isGeofenceTrackingOptedOut = true;
            SdkConfig.getConfig().isDeviceAttributeTrackingOptedOut = true;
            SdkConfig.getConfig().isLocationServiceEnabled = false;
        }
        if (provider.isPushNotificationOptedOut()) {
            Logger.v("MoEDispatcher updateFeatureConfigForOptOutIfRequired() : Push opted out clearing Push Token.");
            provider.clearPushToken();
        }
    }

    void notifyLogoutCompleteListener() {
        Logger.v("MoEDispatcher notifyLogoutCompleteListener() : Notifying listeners");
        for (OnLogoutCompleteListener listener : MoECallbacks.getInstance().getLogoutListenerList()) {
            try {
                listener.logoutComplete();
            }
            catch (Exception e) {
                Logger.e("MoEDispatcher notifyLogoutCompleteListener() : ", e);
            }
        }
    }

    void onAppClose() {
        Logger.v("MoEDispatcher onAppClose(): Application going to background.");
        this.notifyOnAppBackground();
        this.getDeviceAddManager().retryDeviceRegistrationIfRequired(this.context);
        this.shutDownPeriodicFlush();
        MoEDTManager.getInstance().scheduleBackgroundSync(this.context);
        ConfigurationProvider.getInstance(this.context).saveSentScreenNames(ConfigurationCache.getInstance().getSentScreenNames());
        PushAmpManager.getInstance().scheduleServerSync(this.context);
        GeoManager.getInstance().scheduleBackgroundSync(this.context);
        this.trackAppExit();
        AnalyticsHelper.getInstance(this.context).onAppClose(this.context);
        InAppManager.getInstance().onAppClose(this.context);
    }

    private void notifyOnAppBackground() {
        for (OnAppBackgroundListener onAppBackgroundListener : MoECallbacks.getInstance().getBackgroundListenerList()) {
            try {
                onAppBackgroundListener.goingToBackground();
            }
            catch (Exception e) {
                Logger.e("MoEDispatcher notifyOnAppBackground() : ", e);
            }
        }
        for (AppBackgroundListener appBackgroundListener : MoECallbacks.getInstance().getAppBackgroundListeners()) {
            try {
                appBackgroundListener.onAppBackground(this.context);
            }
            catch (Exception e) {
                Logger.e("MoEDispatcher notifyOnAppBackground() : ", e);
            }
        }
    }

    private void trackAppExit() {
        MoEHelper.getInstance(this.context).trackEvent("MOE_APP_EXIT", new PayloadBuilder());
    }

    public MoEAttributeManager getAttributeManager() {
        return this.attributeManager;
    }

    public DeviceAddManager getDeviceAddManager() {
        if (this.deviceAddManager == null) {
            this.deviceAddManager = new DeviceAddManager();
        }
        return this.deviceAddManager;
    }

    public MoECoreEvaluator getCoreEvaluator() {
        if (this.coreEvaluator == null) {
            this.coreEvaluator = new MoECoreEvaluator();
        }
        return this.coreEvaluator;
    }

    public ReportsBatchHelper getBatchHelper() {
        if (this.batchHelper == null) {
            this.batchHelper = new ReportsBatchHelper();
        }
        return this.batchHelper;
    }

    private void onConfigApiSyncComplete(TaskResult taskResult) {
        if (taskResult == null || !taskResult.isSuccess()) {
            return;
        }
        if (MoEUtils.canEnableMiPush(RemoteConfig.getConfig())) {
            ConfigurationProvider.getInstance(this.context).savePushService("MI_PUSH");
            MiPushManager.getInstance().initMiPush(MoEHelper.getInstance(this.context).getApplication());
        } else {
            ConfigurationProvider.getInstance(this.context).removeKey("mi_push_token");
            ConfigurationProvider.getInstance(this.context).savePushService("FCM");
        }
    }

    public void showInAppFromPush(Bundle bundle) {
        try {
            InAppManager.getInstance().showInAppFromPush(this.context, bundle);
        }
        catch (Exception e) {
            Logger.e("MoEDispatcher showInAppFromPush() : ", e);
        }
    }
}

