package com.moengage.core;

import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.moengage.core.model.RemoteConfig;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */
public class MoEDTManager {

  private static final String TAG = "MoEDTManager";
  private DTHandler triggerHandler;

  private MoEDTManager(){
    loadHandler();
  }

  private static MoEDTManager instance;

  public static MoEDTManager getInstance(){
    if (instance == null){
      synchronized (MoEDTManager.class) {
       if (instance == null) instance = new MoEDTManager();
      }
    }
    return instance;
  }

  private void loadHandler(){
    try {
      Class handler = Class.forName("com.moengage.addon.trigger.DTHandlerImpl");
      triggerHandler = (DTHandler) handler.newInstance();
    }catch (Exception e){
      Logger.e( TAG + "loadHandler() : " + "");
    }
  }

  @Nullable
  DTHandler getTriggerHandler(Context context){
    if (RemoteConfig.getConfig().isRealTimeTriggerEnabled &&
        !ConfigurationProvider.getInstance(context).isPushNotificationOptedOut()) return
        triggerHandler;
    return null;
  }

  public void showTriggerIfPossible(Context context, String eventName, JSONObject eventAttributes){
    DTHandler dtHandler = getTriggerHandler(context);
    if (dtHandler != null){
      dtHandler.showTriggerCampaignIfPossible(context, eventName, eventAttributes);
    }
  }

  public void syncDeviceTriggersIfRequired(Context context){
    DTHandler dtHandler = getTriggerHandler(context);
    if (dtHandler != null){
      dtHandler.syncTriggersIfRequired(context);
    }
  }

  public void forceSyncDeviceTriggers(Context context){
    DTHandler dtHandler = getTriggerHandler(context);
    if (dtHandler != null){
      dtHandler.forceSyncDeviceTriggers(context);
    }
  }

  void scheduleBackgroundSync(Context context){
    DTHandler dtHandler = getTriggerHandler(context);
    if (dtHandler != null){
      dtHandler.scheduleBackgroundSync(context);
    }
  }

  @Keep
  public interface DTHandler {

    /**
     * Fetch the trigger list from server if lastSyncTime + minimumDelay < currentTime
     * @param context Application Context
     */
    void syncTriggersIfRequired(@NonNull Context context);

    /**
     * Checks whether a given event is a device trigger event or not and shows device trigger
     * campaign if required.
     *
     * @param context Application context
     * @param eventName event name for which device trigger might be present
     * @param eventAttributes event attributes of the event in question
     */
    void showTriggerCampaignIfPossible(@NonNull Context context, @NonNull String eventName, @NonNull
        JSONObject
        eventAttributes);

    /**
     * Fetch device triggers from server without any condition.
     *
     * @param context Application Context
     */
    void forceSyncDeviceTriggers(@NonNull Context context);

    /**
     * Scheduling background sync
     *
     * @param context Application context
     */
    void scheduleBackgroundSync(Context context);
  }
}
