/* ************************************************************************
 *
 * MOENGAGE CONFIDENTIAL
 * __________________
 *
 *  [2014] - [2015] MoEngage Inc.
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary.models;

import android.support.annotation.Nullable;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.MoECoreEvaluator;
import com.moengage.core.MoEUtils;
import org.json.JSONObject;

/**
 * Represents a tracking event
 *
 * @author MoEngage (abhishek@moenegage.com)
 * @version 5.0
 * @since 5.0
 */
public class Event {

  public long _id;
  public String details;
  public long time;
  @Nullable public String eventName;
  @Nullable public JSONObject attributes;
  public boolean isInteractiveEvent = true;

  public Event(int _id, String details) {
    this(_id, -1, details, null, null);
  }

  public Event(int _id, long time, String details, String eventName, JSONObject attributes) {
    if (_id != -1) {
      this._id = _id;
    }
    if (time != -1) {
      this.time = time;
    } else {
      this.time = MoEUtils.currentTime();
    }
    this.details = details;
    this.eventName = eventName;
    this.attributes = attributes;
    this.isInteractiveEvent = new MoECoreEvaluator().isInteractiveEvent(details);
  }

  public Event(String action, JSONObject attrs) {
    this(-1, -1, MoEHelperUtils.getDatapointJSON(action, attrs).toString(), action, attrs);
  }
}
