/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.remoteconfig.RemoteConfigDefault;
import com.moengage.core.utils.ApiUtility;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteConfig {
    public boolean isLogEntryEnabled = RemoteConfigDefault.LOG_ENTRY_STATUS;
    @Nullable
    public String logEntryToken = RemoteConfigDefault.LOG_ENTRY_TOKEN;
    public long pushAmpSyncDelay = RemoteConfigDefault.PUSH_AMP_SYNC_INTERVAL;
    @Nullable
    public Set<String> blacklistedEvents;
    public boolean isAppEnabled = RemoteConfigDefault.ACCOUNT_STATUS;
    public boolean isInAppEnabled = RemoteConfigDefault.IN_APP_STATUS;
    public boolean isGeofenceEnabled = RemoteConfigDefault.GEO_FENCE_STATUS;
    public boolean isPushAmpEnabled = RemoteConfigDefault.PUSH_AMP_STATUS;
    public int eventBatchCount = RemoteConfigDefault.EVENT_BATCH_COUNT;
    public long dataSyncRetryInterval = RemoteConfigDefault.DATA_SYNC_RETRY_INTERVAL;
    public Set<String> flushEvents;
    public boolean isPeriodicFlushEnabled = RemoteConfigDefault.PERIODIC_FLUSH_STATE;
    public long periodicFlushTime = RemoteConfigDefault.PERIODIC_FLUSH_TIME;
    public long pushAmpCampaignExpiryTime = RemoteConfigDefault.PUSH_AMP_CAMPAIGN_EXPIRY_TIME;
    public boolean isRealTimeTriggerEnabled = RemoteConfigDefault.REAL_TIME_TRIGGER_STATUS;
    public long realTimeTriggerBackgroundSyncInterval = RemoteConfigDefault.REAL_TIME_TRIGGER_SYNC_INTERVAL;
    public Set<String> gdprWhitelistEventList;
    public long userAttributeCachingTime = RemoteConfigDefault.USER_ATTRIBUTE_CACHING_TIME;
    @Nullable
    public List<String> blockedUniqueIdRegex;
    public long sessionInActiveTime = RemoteConfigDefault.DEFAULT_SESSION_INACTIVE_TIME;
    public Set<String> additionalSourceIdentifiers = new HashSet<String>();
    public boolean isPushAmpPlusEnabled;
    public String miAppKey;
    public String miAppId;
    private static final String TAG = "RemoteConfig";
    private static final String RESPONSE_ATTR_LOG_ENTRY_STATUS = "le_s";
    private static final String RESPONSE_ATTR_LOG_ENTRY_TOKEN = "le_tkn";
    private static final String RESPONSE_ATTR_PUSH_AMP_SYNC_DELAY = "m_s_t";
    private static final String RESPONSE_ATTR_BLACKLIST_EVENT = "b_e";
    private static final String RESPONSE_ATTR_APP_STATE = "a_s";
    private static final String RESPONSE_ATTR_IN_APP_STATE = "i_s";
    private static final String RESPONSE_ATTR_GEO_STATE = "g_s";
    private static final String RESPONSE_ATTR_PUSH_AMP_STATE = "in_s";
    private static final String RESPONSE_ATTR_EVENT_SYNC_COUNT = "e_b_c";
    private static final String RESPONSE_ATTR_DATA_SYNC_RETRY_INTERVAL = "d_s_r_i";
    private static final String RESPONSE_ATTR_FLUSH_EVENTS = "f_e";
    private static final String RESPONSE_ATTR_PERIODIC_FLUSH_TIME = "p_f_t";
    private static final String RESPONSE_ATTR_PERIODIC_FLUSH_STATE = "p_f_s";
    private static final String RESPONSE_ATTR_CAMPAIGN_ID_EXPIRY = "cid_ex";
    private static final String RESPONSE_ATTR_REAL_TIME_TRIGGER_STATE = "d_t";
    private static final String RESPONSE_ATTR_REAL_TIME_TRIGGER_SYNC_TIME = "dt_s_t";
    private static final String RESPONSE_ATTR_GDPR_WHITELIST_EVENTS = "d_t_w_e";
    private static final String RESPONSE_ATTR_USER_ATTRIBUTE_CACHING_TIME = "u_a_c_t";
    private static final String RESPONSE_ATTR_BLOCKED_UNIQUE_ID_REGEX = "b_uid_r";
    private static final String RESPONSE_ATTR_SESSION_INACTIVE_TIME = "s_i_d";
    private static final String RESPONSE_ATTR_TRAFFIC_SOURCE_EXTRA_IDENTIFIERS = "src_ext";
    private static final String RESPONSE_ATTR_MI_PUSH_APP_ID = "mi_app_id";
    private static final String RESPONSE_ATTR_MI_PUSH_APP_KEY = "mi_app_key";
    private static final String RESPONSE_ATTR_MI_PUSH_STATUS = "mi_p_s";
    private static RemoteConfig remoteConfig;

    public RemoteConfig() {
        this.flushEvents = new HashSet<String>();
        this.flushEvents.addAll(RemoteConfigDefault.DEFAULT_FLUSH_EVENTS);
        this.gdprWhitelistEventList = new HashSet<String>();
        this.gdprWhitelistEventList.addAll(RemoteConfigDefault.DEFAULT_GDPR_WHITELIST_EVENTS);
        this.isPushAmpPlusEnabled = RemoteConfigDefault.MI_PUSH_APP_STATUS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteConfig that = (RemoteConfig)o;
        if (this.isLogEntryEnabled != that.isLogEntryEnabled) {
            return false;
        }
        if (this.pushAmpSyncDelay != that.pushAmpSyncDelay) {
            return false;
        }
        if (this.isAppEnabled != that.isAppEnabled) {
            return false;
        }
        if (this.isInAppEnabled != that.isInAppEnabled) {
            return false;
        }
        if (this.isGeofenceEnabled != that.isGeofenceEnabled) {
            return false;
        }
        if (this.isPushAmpEnabled != that.isPushAmpEnabled) {
            return false;
        }
        if (this.eventBatchCount != that.eventBatchCount) {
            return false;
        }
        if (this.dataSyncRetryInterval != that.dataSyncRetryInterval) {
            return false;
        }
        if (this.isPeriodicFlushEnabled != that.isPeriodicFlushEnabled) {
            return false;
        }
        if (this.periodicFlushTime != that.periodicFlushTime) {
            return false;
        }
        if (this.pushAmpCampaignExpiryTime != that.pushAmpCampaignExpiryTime) {
            return false;
        }
        if (this.isRealTimeTriggerEnabled != that.isRealTimeTriggerEnabled) {
            return false;
        }
        if (this.realTimeTriggerBackgroundSyncInterval != that.realTimeTriggerBackgroundSyncInterval) {
            return false;
        }
        if (this.userAttributeCachingTime != that.userAttributeCachingTime) {
            return false;
        }
        if (this.sessionInActiveTime != that.sessionInActiveTime) {
            return false;
        }
        if (this.logEntryToken != null ? !this.logEntryToken.equals(that.logEntryToken) : that.logEntryToken != null) {
            return false;
        }
        if (this.blacklistedEvents != null ? !this.blacklistedEvents.equals(that.blacklistedEvents) : that.blacklistedEvents != null) {
            return false;
        }
        if (this.flushEvents != null ? !this.flushEvents.equals(that.flushEvents) : that.flushEvents != null) {
            return false;
        }
        if (this.gdprWhitelistEventList != null ? !this.gdprWhitelistEventList.equals(that.gdprWhitelistEventList) : that.gdprWhitelistEventList != null) {
            return false;
        }
        return this.blockedUniqueIdRegex != null ? this.blockedUniqueIdRegex.equals(that.blockedUniqueIdRegex) : that.blockedUniqueIdRegex == null;
    }

    public static RemoteConfig fromJson(JSONObject configurationJson) {
        try {
            Set<String> identifiers;
            Set<String> whitelistedEvents;
            Set<String> events;
            long syncDelay;
            RemoteConfig configuration = new RemoteConfig();
            if (configurationJson.has(RESPONSE_ATTR_LOG_ENTRY_STATUS)) {
                configuration.isLogEntryEnabled = RemoteConfig.getStateFromResponse(configurationJson, RESPONSE_ATTR_LOG_ENTRY_STATUS, RemoteConfigDefault.LOG_ENTRY_STATUS);
            }
            if (configurationJson.has(RESPONSE_ATTR_LOG_ENTRY_TOKEN)) {
                configuration.logEntryToken = configurationJson.getString(RESPONSE_ATTR_LOG_ENTRY_TOKEN);
            }
            if (configurationJson.has(RESPONSE_ATTR_PUSH_AMP_SYNC_DELAY) && (syncDelay = configurationJson.getLong(RESPONSE_ATTR_PUSH_AMP_SYNC_DELAY)) > 0L) {
                configuration.pushAmpSyncDelay = syncDelay * 1000L;
            }
            if (configurationJson.has(RESPONSE_ATTR_BLACKLIST_EVENT)) {
                configuration.blacklistedEvents = ApiUtility.jsonArrayToStringSet(configurationJson.getJSONArray(RESPONSE_ATTR_BLACKLIST_EVENT));
            }
            if (configurationJson.has(RESPONSE_ATTR_APP_STATE)) {
                configuration.isAppEnabled = RemoteConfig.getStateFromResponse(configurationJson, RESPONSE_ATTR_APP_STATE, RemoteConfigDefault.ACCOUNT_STATUS);
            }
            if (configurationJson.has(RESPONSE_ATTR_IN_APP_STATE)) {
                configuration.isInAppEnabled = RemoteConfig.getStateFromResponse(configurationJson, RESPONSE_ATTR_IN_APP_STATE, RemoteConfigDefault.IN_APP_STATUS);
            }
            if (configurationJson.has(RESPONSE_ATTR_GEO_STATE)) {
                configuration.isGeofenceEnabled = RemoteConfig.getStateFromResponse(configurationJson, RESPONSE_ATTR_GEO_STATE, RemoteConfigDefault.GEO_FENCE_STATUS);
            }
            if (configurationJson.has(RESPONSE_ATTR_PUSH_AMP_STATE)) {
                configuration.isPushAmpEnabled = RemoteConfig.getStateFromResponse(configurationJson, RESPONSE_ATTR_PUSH_AMP_STATE, RemoteConfigDefault.PUSH_AMP_STATUS);
            }
            if (configurationJson.has(RESPONSE_ATTR_EVENT_SYNC_COUNT)) {
                configuration.eventBatchCount = configurationJson.getInt(RESPONSE_ATTR_EVENT_SYNC_COUNT);
            }
            if (configurationJson.has(RESPONSE_ATTR_DATA_SYNC_RETRY_INTERVAL)) {
                configuration.dataSyncRetryInterval = configurationJson.getLong(RESPONSE_ATTR_DATA_SYNC_RETRY_INTERVAL) * 1000L;
            }
            if (configurationJson.has(RESPONSE_ATTR_FLUSH_EVENTS) && (events = ApiUtility.jsonArrayToStringSet(configurationJson.getJSONArray(RESPONSE_ATTR_FLUSH_EVENTS))) != null) {
                configuration.flushEvents.addAll(events);
            }
            if (configurationJson.has(RESPONSE_ATTR_PERIODIC_FLUSH_STATE)) {
                configuration.isPeriodicFlushEnabled = RemoteConfig.getStateFromResponse(configurationJson, RESPONSE_ATTR_PERIODIC_FLUSH_STATE, RemoteConfigDefault.PERIODIC_FLUSH_STATE);
            }
            if (configurationJson.has(RESPONSE_ATTR_PERIODIC_FLUSH_TIME)) {
                configuration.periodicFlushTime = configurationJson.getLong(RESPONSE_ATTR_PERIODIC_FLUSH_TIME);
            }
            if (configurationJson.has(RESPONSE_ATTR_CAMPAIGN_ID_EXPIRY)) {
                configuration.pushAmpCampaignExpiryTime = configurationJson.getLong(RESPONSE_ATTR_CAMPAIGN_ID_EXPIRY);
            }
            if (configurationJson.has(RESPONSE_ATTR_REAL_TIME_TRIGGER_STATE)) {
                configuration.isRealTimeTriggerEnabled = RemoteConfig.getStateFromResponse(configurationJson, RESPONSE_ATTR_REAL_TIME_TRIGGER_STATE, RemoteConfigDefault.REAL_TIME_TRIGGER_STATUS);
            }
            if (configurationJson.has(RESPONSE_ATTR_REAL_TIME_TRIGGER_SYNC_TIME)) {
                configuration.realTimeTriggerBackgroundSyncInterval = configurationJson.getLong(RESPONSE_ATTR_REAL_TIME_TRIGGER_SYNC_TIME) * 1000L;
            }
            if (configurationJson.has(RESPONSE_ATTR_GDPR_WHITELIST_EVENTS) && (whitelistedEvents = ApiUtility.jsonArrayToStringSet(configurationJson.getJSONArray(RESPONSE_ATTR_GDPR_WHITELIST_EVENTS))) != null) {
                configuration.gdprWhitelistEventList.addAll(whitelistedEvents);
            }
            if (configurationJson.has(RESPONSE_ATTR_USER_ATTRIBUTE_CACHING_TIME)) {
                configuration.userAttributeCachingTime = configurationJson.getLong(RESPONSE_ATTR_USER_ATTRIBUTE_CACHING_TIME) * 1000L;
            }
            if (configurationJson.has(RESPONSE_ATTR_BLOCKED_UNIQUE_ID_REGEX)) {
                configuration.blockedUniqueIdRegex = ApiUtility.jsonArrayToStringList(configurationJson.getJSONArray(RESPONSE_ATTR_BLOCKED_UNIQUE_ID_REGEX));
            }
            if (configurationJson.has(RESPONSE_ATTR_SESSION_INACTIVE_TIME)) {
                configuration.sessionInActiveTime = configurationJson.getLong(RESPONSE_ATTR_SESSION_INACTIVE_TIME) * 1000L;
            }
            if (configurationJson.has(RESPONSE_ATTR_TRAFFIC_SOURCE_EXTRA_IDENTIFIERS) && (identifiers = ApiUtility.jsonArrayToStringSet(configurationJson.getJSONArray(RESPONSE_ATTR_TRAFFIC_SOURCE_EXTRA_IDENTIFIERS))) != null) {
                configuration.additionalSourceIdentifiers = identifiers;
            }
            if (configurationJson.has(RESPONSE_ATTR_MI_PUSH_APP_ID)) {
                configuration.miAppId = configurationJson.getString(RESPONSE_ATTR_MI_PUSH_APP_ID);
            }
            if (configurationJson.has(RESPONSE_ATTR_MI_PUSH_APP_KEY)) {
                configuration.miAppKey = configurationJson.getString(RESPONSE_ATTR_MI_PUSH_APP_KEY);
            }
            if (configurationJson.has(RESPONSE_ATTR_MI_PUSH_STATUS)) {
                configuration.isPushAmpPlusEnabled = RemoteConfig.getStateFromResponse(configurationJson, RESPONSE_ATTR_MI_PUSH_STATUS, RemoteConfigDefault.MI_PUSH_APP_STATUS);
            }
            return configuration;
        }
        catch (Exception e) {
            Logger.f("RemoteConfig parseConfigApiResponse() : Exception ", e);
            return null;
        }
    }

    private static boolean getStateFromResponse(@NonNull JSONObject responseJSON, @NonNull String responseAttr, boolean defaultValue) {
        try {
            String state;
            switch (state = responseJSON.getString(responseAttr)) {
                case "blocked": {
                    return false;
                }
                case "allowed": {
                    return true;
                }
            }
        }
        catch (JSONException e) {
            Logger.f(" getStateFromResponse ", e);
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RemoteConfig getConfig() {
        if (remoteConfig != null) return remoteConfig;
        Class<RemoteConfig> clazz = RemoteConfig.class;
        synchronized (RemoteConfig.class) {
            if (remoteConfig != null) return remoteConfig;
            remoteConfig = new RemoteConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return remoteConfig;
        }
    }

    public static void setRemoteConfig(RemoteConfig config) {
        remoteConfig = config;
    }
}

