/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core;

import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Umang Chamaria
 */
public class ConfigurationCache {

  private HashMap<String, Object> configMap;

  private static ConfigurationCache instance;

  private ConfigurationCache() {
    configMap = new HashMap<>();
    sentScreenNames = new HashSet<>();
  }

  public static ConfigurationCache getInstance() {
    if (instance == null) {
      synchronized (ConfigurationCache.class) {
        if (instance == null) instance = new ConfigurationCache();
      }
    }
    return instance;
  }

  private Set<String> sentScreenNames;

  void initialiseSentScreens(Set<String> sentScreenNames){
    this.sentScreenNames.addAll(sentScreenNames);
  }

  void addScreenToSentList(String screenName){
    sentScreenNames.add(screenName);
  }

  Set<String> getSentScreenNames(){
    return sentScreenNames;
  }


  private static final String INTEGRATION_TYPE = "integration_type";

  public void setIntegrationType(String integrationType){
    configMap.put(INTEGRATION_TYPE, integrationType);
  }

  @Nullable public String getIntegrationType(){
   return configMap.containsKey(INTEGRATION_TYPE) ?
       String.valueOf(configMap.get(INTEGRATION_TYPE)) : null;
  }

  private static final String INTEGRATION_VERSION = "integration_version";

  // intentionally leaving this method here for legacy reasons.
  @Deprecated
  public void setIntegrationVersion(int integrationVersion){

  }

  public void setIntegrationVersion(String integrationVersion){
    configMap.put(INTEGRATION_VERSION, integrationVersion);
  }

  public String getIntegrationVersion(){
    return configMap.containsKey(INTEGRATION_VERSION) ?
        (String) configMap.get(INTEGRATION_VERSION): "";
  }

}
